/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.FieldsMapCopier;
import software.amazon.awssdk.services.appintegrations.model.FolderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileConfiguration> {
    private static final SdkField<List<String>> FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Folders").getter(FileConfiguration.getter(FileConfiguration::folders)).setter(FileConfiguration.setter(Builder::folders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filters").getter(FileConfiguration.getter(FileConfiguration::filters)).setter(FileConfiguration.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDERS_FIELD, FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> folders;
    private final Map<String, List<String>> filters;

    private FileConfiguration(BuilderImpl builder) {
        this.folders = builder.folders;
        this.filters = builder.filters;
    }

    public final boolean hasFolders() {
        return this.folders != null && !(this.folders instanceof SdkAutoConstructList);
    }

    public final List<String> folders() {
        return this.folders;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolders() ? this.folders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileConfiguration)) {
            return false;
        }
        FileConfiguration other = (FileConfiguration)obj;
        return this.hasFolders() == other.hasFolders() && Objects.equals(this.folders(), other.folders()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"FileConfiguration").add("Folders", this.hasFolders() ? this.folders() : null).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Folders": {
                return Optional.ofNullable(clazz.cast(this.folders()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileConfiguration, T> g) {
        return obj -> g.apply((FileConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> folders = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileConfiguration model) {
            this.folders(model.folders);
            this.filters(model.filters);
        }

        public final Collection<String> getFolders() {
            if (this.folders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folders;
        }

        public final void setFolders(Collection<String> folders) {
            this.folders = FolderListCopier.copy(folders);
        }

        @Override
        public final Builder folders(Collection<String> folders) {
            this.folders = FolderListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(String ... folders) {
            this.folders(Arrays.asList(folders));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (this.filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FieldsMapCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FieldsMapCopier.copy(filters);
            return this;
        }

        public FileConfiguration build() {
            return new FileConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileConfiguration> {
        public Builder folders(Collection<String> var1);

        public Builder folders(String ... var1);

        public Builder filters(Map<String, ? extends Collection<String>> var1);
    }
}

