/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClientBuilder;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsServiceClientConfiguration;
import software.amazon.awssdk.services.appintegrations.DefaultAppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.DefaultAppIntegrationsBaseClientBuilder;
import software.amazon.awssdk.services.appintegrations.endpoints.AppIntegrationsEndpointProvider;

@SdkInternalApi
final class DefaultAppIntegrationsAsyncClientBuilder
extends DefaultAppIntegrationsBaseClientBuilder<AppIntegrationsAsyncClientBuilder, AppIntegrationsAsyncClient>
implements AppIntegrationsAsyncClientBuilder {
    DefaultAppIntegrationsAsyncClientBuilder() {
    }

    @Override
    public DefaultAppIntegrationsAsyncClientBuilder endpointProvider(AppIntegrationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppIntegrationsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAppIntegrationsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AppIntegrationsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAppIntegrationsAsyncClient client = new DefaultAppIntegrationsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AppIntegrationsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AppIntegrationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

