/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.EventIntegration;
import software.amazon.awssdk.services.appintegrations.model.EventIntegrationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventIntegrationsResponse
extends AppIntegrationsResponse
implements ToCopyableBuilder<Builder, ListEventIntegrationsResponse> {
    private static final SdkField<List<EventIntegration>> EVENT_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventIntegrations").getter(ListEventIntegrationsResponse.getter(ListEventIntegrationsResponse::eventIntegrations)).setter(ListEventIntegrationsResponse.setter(Builder::eventIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEventIntegrationsResponse.getter(ListEventIntegrationsResponse::nextToken)).setter(ListEventIntegrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INTEGRATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventIntegration> eventIntegrations;
    private final String nextToken;

    private ListEventIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventIntegrations = builder.eventIntegrations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventIntegrations() {
        return this.eventIntegrations != null && !(this.eventIntegrations instanceof SdkAutoConstructList);
    }

    public final List<EventIntegration> eventIntegrations() {
        return this.eventIntegrations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventIntegrations() ? this.eventIntegrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventIntegrationsResponse)) {
            return false;
        }
        ListEventIntegrationsResponse other = (ListEventIntegrationsResponse)((Object)obj);
        return this.hasEventIntegrations() == other.hasEventIntegrations() && Objects.equals(this.eventIntegrations(), other.eventIntegrations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventIntegrationsResponse").add("EventIntegrations", this.hasEventIntegrations() ? this.eventIntegrations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventIntegrations": {
                return Optional.ofNullable(clazz.cast(this.eventIntegrations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventIntegrationsResponse, T> g) {
        return obj -> g.apply((ListEventIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<EventIntegration> eventIntegrations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventIntegrationsResponse model) {
            super(model);
            this.eventIntegrations(model.eventIntegrations);
            this.nextToken(model.nextToken);
        }

        public final List<EventIntegration.Builder> getEventIntegrations() {
            List<EventIntegration.Builder> result = EventIntegrationsListCopier.copyToBuilder(this.eventIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventIntegrations(Collection<EventIntegration.BuilderImpl> eventIntegrations) {
            this.eventIntegrations = EventIntegrationsListCopier.copyFromBuilder(eventIntegrations);
        }

        @Override
        @Transient
        public final Builder eventIntegrations(Collection<EventIntegration> eventIntegrations) {
            this.eventIntegrations = EventIntegrationsListCopier.copy(eventIntegrations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventIntegrations(EventIntegration ... eventIntegrations) {
            this.eventIntegrations(Arrays.asList(eventIntegrations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventIntegrations(Consumer<EventIntegration.Builder> ... eventIntegrations) {
            this.eventIntegrations(Stream.of(eventIntegrations).map(c -> (EventIntegration)((EventIntegration.Builder)EventIntegration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventIntegrationsResponse build() {
            return new ListEventIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventIntegrationsResponse> {
        public Builder eventIntegrations(Collection<EventIntegration> var1);

        public Builder eventIntegrations(EventIntegration ... var1);

        public Builder eventIntegrations(Consumer<EventIntegration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

