/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration;
import software.amazon.awssdk.services.appintegrations.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataIntegrationResponse
extends AppIntegrationsResponse
implements ToCopyableBuilder<Builder, CreateDataIntegrationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::arn)).setter(CreateDataIntegrationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::id)).setter(CreateDataIntegrationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::name)).setter(CreateDataIntegrationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::description)).setter(CreateDataIntegrationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::kmsKey)).setter(CreateDataIntegrationResponse.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceURI").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::sourceURI)).setter(CreateDataIntegrationResponse.setter(Builder::sourceURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceURI").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::scheduleConfiguration)).setter(CreateDataIntegrationResponse.setter(Builder::scheduleConfiguration)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::tags)).setter(CreateDataIntegrationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateDataIntegrationResponse.getter(CreateDataIntegrationResponse::clientToken)).setter(CreateDataIntegrationResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, KMS_KEY_FIELD, SOURCE_URI_FIELD, SCHEDULE_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String arn;
    private final String id;
    private final String name;
    private final String description;
    private final String kmsKey;
    private final String sourceURI;
    private final ScheduleConfiguration scheduleConfiguration;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateDataIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKey = builder.kmsKey;
        this.sourceURI = builder.sourceURI;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String sourceURI() {
        return this.sourceURI;
    }

    public final ScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationResponse)) {
            return false;
        }
        CreateDataIntegrationResponse other = (CreateDataIntegrationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.sourceURI(), other.sourceURI()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataIntegrationResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("KmsKey", (Object)this.kmsKey()).add("SourceURI", (Object)this.sourceURI()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "SourceURI": {
                return Optional.ofNullable(clazz.cast(this.sourceURI()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationResponse, T> g) {
        return obj -> g.apply((CreateDataIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String description;
        private String kmsKey;
        private String sourceURI;
        private ScheduleConfiguration scheduleConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.kmsKey(model.kmsKey);
            this.sourceURI(model.sourceURI);
            this.scheduleConfiguration(model.scheduleConfiguration);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        @Transient
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getSourceURI() {
            return this.sourceURI;
        }

        public final void setSourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
        }

        @Override
        @Transient
        public final Builder sourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateDataIntegrationResponse build() {
            return new CreateDataIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataIntegrationResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder kmsKey(String var1);

        public Builder sourceURI(String var1);

        public Builder scheduleConfiguration(ScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);
    }
}

