/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.EventFilter;
import software.amazon.awssdk.services.appintegrations.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventIntegration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventIntegration> {
    private static final SdkField<String> EVENT_INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventIntegrationArn").getter(EventIntegration.getter(EventIntegration::eventIntegrationArn)).setter(EventIntegration.setter(Builder::eventIntegrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EventIntegration.getter(EventIntegration::name)).setter(EventIntegration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EventIntegration.getter(EventIntegration::description)).setter(EventIntegration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<EventFilter> EVENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventFilter").getter(EventIntegration.getter(EventIntegration::eventFilter)).setter(EventIntegration.setter(Builder::eventFilter)).constructor(EventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()}).build();
    private static final SdkField<String> EVENT_BRIDGE_BUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBridgeBus").getter(EventIntegration.getter(EventIntegration::eventBridgeBus)).setter(EventIntegration.setter(Builder::eventBridgeBus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeBus").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(EventIntegration.getter(EventIntegration::tags)).setter(EventIntegration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INTEGRATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EVENT_FILTER_FIELD, EVENT_BRIDGE_BUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventIntegrationArn;
    private final String name;
    private final String description;
    private final EventFilter eventFilter;
    private final String eventBridgeBus;
    private final Map<String, String> tags;

    private EventIntegration(BuilderImpl builder) {
        this.eventIntegrationArn = builder.eventIntegrationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.eventFilter = builder.eventFilter;
        this.eventBridgeBus = builder.eventBridgeBus;
        this.tags = builder.tags;
    }

    public String eventIntegrationArn() {
        return this.eventIntegrationArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public EventFilter eventFilter() {
        return this.eventFilter;
    }

    public String eventBridgeBus() {
        return this.eventBridgeBus;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIntegrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeBus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventIntegration)) {
            return false;
        }
        EventIntegration other = (EventIntegration)obj;
        return Objects.equals(this.eventIntegrationArn(), other.eventIntegrationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.eventFilter(), other.eventFilter()) && Objects.equals(this.eventBridgeBus(), other.eventBridgeBus()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"EventIntegration").add("EventIntegrationArn", (Object)this.eventIntegrationArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EventFilter", (Object)this.eventFilter()).add("EventBridgeBus", (Object)this.eventBridgeBus()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventIntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.eventIntegrationArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventFilter": {
                return Optional.ofNullable(clazz.cast(this.eventFilter()));
            }
            case "EventBridgeBus": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeBus()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventIntegration, T> g) {
        return obj -> g.apply((EventIntegration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventIntegrationArn;
        private String name;
        private String description;
        private EventFilter eventFilter;
        private String eventBridgeBus;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventIntegration model) {
            this.eventIntegrationArn(model.eventIntegrationArn);
            this.name(model.name);
            this.description(model.description);
            this.eventFilter(model.eventFilter);
            this.eventBridgeBus(model.eventBridgeBus);
            this.tags(model.tags);
        }

        public final String getEventIntegrationArn() {
            return this.eventIntegrationArn;
        }

        @Override
        public final Builder eventIntegrationArn(String eventIntegrationArn) {
            this.eventIntegrationArn = eventIntegrationArn;
            return this;
        }

        public final void setEventIntegrationArn(String eventIntegrationArn) {
            this.eventIntegrationArn = eventIntegrationArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final EventFilter.Builder getEventFilter() {
            return this.eventFilter != null ? this.eventFilter.toBuilder() : null;
        }

        @Override
        public final Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final void setEventFilter(EventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        public final String getEventBridgeBus() {
            return this.eventBridgeBus;
        }

        @Override
        public final Builder eventBridgeBus(String eventBridgeBus) {
            this.eventBridgeBus = eventBridgeBus;
            return this;
        }

        public final void setEventBridgeBus(String eventBridgeBus) {
            this.eventBridgeBus = eventBridgeBus;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public EventIntegration build() {
            return new EventIntegration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventIntegration> {
        public Builder eventIntegrationArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder eventFilter(EventFilter var1);

        default public Builder eventFilter(Consumer<EventFilter.Builder> eventFilter) {
            return this.eventFilter((EventFilter)((EventFilter.Builder)EventFilter.builder().applyMutation(eventFilter)).build());
        }

        public Builder eventBridgeBus(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

