/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.ConnectorSuppliedValueOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorRuntimeSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorRuntimeSetting> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::key)).setter(ConnectorRuntimeSetting.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::dataType)).setter(ConnectorRuntimeSetting.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRequired").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::isRequired)).setter(ConnectorRuntimeSetting.setter(Builder::isRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequired").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("label").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::label)).setter(ConnectorRuntimeSetting.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::description)).setter(ConnectorRuntimeSetting.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::scope)).setter(ConnectorRuntimeSetting.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<List<String>> CONNECTOR_SUPPLIED_VALUE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorSuppliedValueOptions").getter(ConnectorRuntimeSetting.getter(ConnectorRuntimeSetting::connectorSuppliedValueOptions)).setter(ConnectorRuntimeSetting.setter(Builder::connectorSuppliedValueOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSuppliedValueOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DATA_TYPE_FIELD, IS_REQUIRED_FIELD, LABEL_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, CONNECTOR_SUPPLIED_VALUE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorRuntimeSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String dataType;
    private final Boolean isRequired;
    private final String label;
    private final String description;
    private final String scope;
    private final List<String> connectorSuppliedValueOptions;

    private ConnectorRuntimeSetting(BuilderImpl builder) {
        this.key = builder.key;
        this.dataType = builder.dataType;
        this.isRequired = builder.isRequired;
        this.label = builder.label;
        this.description = builder.description;
        this.scope = builder.scope;
        this.connectorSuppliedValueOptions = builder.connectorSuppliedValueOptions;
    }

    public final String key() {
        return this.key;
    }

    public final String dataType() {
        return this.dataType;
    }

    public final Boolean isRequired() {
        return this.isRequired;
    }

    public final String label() {
        return this.label;
    }

    public final String description() {
        return this.description;
    }

    public final String scope() {
        return this.scope;
    }

    public final boolean hasConnectorSuppliedValueOptions() {
        return this.connectorSuppliedValueOptions != null && !(this.connectorSuppliedValueOptions instanceof SdkAutoConstructList);
    }

    public final List<String> connectorSuppliedValueOptions() {
        return this.connectorSuppliedValueOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorSuppliedValueOptions() ? this.connectorSuppliedValueOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorRuntimeSetting)) {
            return false;
        }
        ConnectorRuntimeSetting other = (ConnectorRuntimeSetting)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.isRequired(), other.isRequired()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scope(), other.scope()) && this.hasConnectorSuppliedValueOptions() == other.hasConnectorSuppliedValueOptions() && Objects.equals(this.connectorSuppliedValueOptions(), other.connectorSuppliedValueOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorRuntimeSetting").add("Key", (Object)this.key()).add("DataType", (Object)this.dataType()).add("IsRequired", (Object)this.isRequired()).add("Label", (Object)this.label()).add("Description", (Object)this.description()).add("Scope", (Object)this.scope()).add("ConnectorSuppliedValueOptions", this.hasConnectorSuppliedValueOptions() ? this.connectorSuppliedValueOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "isRequired": {
                return Optional.ofNullable(clazz.cast(this.isRequired()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "connectorSuppliedValueOptions": {
                return Optional.ofNullable(clazz.cast(this.connectorSuppliedValueOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("isRequired", IS_REQUIRED_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("connectorSuppliedValueOptions", CONNECTOR_SUPPLIED_VALUE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorRuntimeSetting, T> g) {
        return obj -> g.apply((ConnectorRuntimeSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String dataType;
        private Boolean isRequired;
        private String label;
        private String description;
        private String scope;
        private List<String> connectorSuppliedValueOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorRuntimeSetting model) {
            this.key(model.key);
            this.dataType(model.dataType);
            this.isRequired(model.isRequired);
            this.label(model.label);
            this.description(model.description);
            this.scope(model.scope);
            this.connectorSuppliedValueOptions(model.connectorSuppliedValueOptions);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final Boolean getIsRequired() {
            return this.isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getConnectorSuppliedValueOptions() {
            if (this.connectorSuppliedValueOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorSuppliedValueOptions;
        }

        public final void setConnectorSuppliedValueOptions(Collection<String> connectorSuppliedValueOptions) {
            this.connectorSuppliedValueOptions = ConnectorSuppliedValueOptionListCopier.copy(connectorSuppliedValueOptions);
        }

        @Override
        public final Builder connectorSuppliedValueOptions(Collection<String> connectorSuppliedValueOptions) {
            this.connectorSuppliedValueOptions = ConnectorSuppliedValueOptionListCopier.copy(connectorSuppliedValueOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorSuppliedValueOptions(String ... connectorSuppliedValueOptions) {
            this.connectorSuppliedValueOptions(Arrays.asList(connectorSuppliedValueOptions));
            return this;
        }

        public ConnectorRuntimeSetting build() {
            return new ConnectorRuntimeSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorRuntimeSetting> {
        public Builder key(String var1);

        public Builder dataType(String var1);

        public Builder isRequired(Boolean var1);

        public Builder label(String var1);

        public Builder description(String var1);

        public Builder scope(String var1);

        public Builder connectorSuppliedValueOptions(Collection<String> var1);

        public Builder connectorSuppliedValueOptions(String ... var1);
    }
}

