/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when using Veeva as a flow source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VeevaSourceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<VeevaSourceProperties.Builder, VeevaSourceProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("object")
            .getter(getter(VeevaSourceProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()).build();

    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentType").getter(getter(VeevaSourceProperties::documentType)).setter(setter(Builder::documentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentType").build()).build();

    private static final SdkField<Boolean> INCLUDE_SOURCE_FILES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeSourceFiles").getter(getter(VeevaSourceProperties::includeSourceFiles))
            .setter(setter(Builder::includeSourceFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSourceFiles").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_RENDITIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeRenditions").getter(getter(VeevaSourceProperties::includeRenditions))
            .setter(setter(Builder::includeRenditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeRenditions").build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_VERSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeAllVersions").getter(getter(VeevaSourceProperties::includeAllVersions))
            .setter(setter(Builder::includeAllVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAllVersions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD,
            DOCUMENT_TYPE_FIELD, INCLUDE_SOURCE_FILES_FIELD, INCLUDE_RENDITIONS_FIELD, INCLUDE_ALL_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String object;

    private final String documentType;

    private final Boolean includeSourceFiles;

    private final Boolean includeRenditions;

    private final Boolean includeAllVersions;

    private VeevaSourceProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.documentType = builder.documentType;
        this.includeSourceFiles = builder.includeSourceFiles;
        this.includeRenditions = builder.includeRenditions;
        this.includeAllVersions = builder.includeAllVersions;
    }

    /**
     * <p>
     * The object specified in the Veeva flow source.
     * </p>
     * 
     * @return The object specified in the Veeva flow source.
     */
    public final String object() {
        return object;
    }

    /**
     * <p>
     * The document type specified in the Veeva document extract flow.
     * </p>
     * 
     * @return The document type specified in the Veeva document extract flow.
     */
    public final String documentType() {
        return documentType;
    }

    /**
     * <p>
     * Boolean value to include source files in Veeva document extract flow.
     * </p>
     * 
     * @return Boolean value to include source files in Veeva document extract flow.
     */
    public final Boolean includeSourceFiles() {
        return includeSourceFiles;
    }

    /**
     * <p>
     * Boolean value to include file renditions in Veeva document extract flow.
     * </p>
     * 
     * @return Boolean value to include file renditions in Veeva document extract flow.
     */
    public final Boolean includeRenditions() {
        return includeRenditions;
    }

    /**
     * <p>
     * Boolean value to include All Versions of files in Veeva document extract flow.
     * </p>
     * 
     * @return Boolean value to include All Versions of files in Veeva document extract flow.
     */
    public final Boolean includeAllVersions() {
        return includeAllVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(documentType());
        hashCode = 31 * hashCode + Objects.hashCode(includeSourceFiles());
        hashCode = 31 * hashCode + Objects.hashCode(includeRenditions());
        hashCode = 31 * hashCode + Objects.hashCode(includeAllVersions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VeevaSourceProperties)) {
            return false;
        }
        VeevaSourceProperties other = (VeevaSourceProperties) obj;
        return Objects.equals(object(), other.object()) && Objects.equals(documentType(), other.documentType())
                && Objects.equals(includeSourceFiles(), other.includeSourceFiles())
                && Objects.equals(includeRenditions(), other.includeRenditions())
                && Objects.equals(includeAllVersions(), other.includeAllVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VeevaSourceProperties").add("Object", object()).add("DocumentType", documentType())
                .add("IncludeSourceFiles", includeSourceFiles()).add("IncludeRenditions", includeRenditions())
                .add("IncludeAllVersions", includeAllVersions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "object":
            return Optional.ofNullable(clazz.cast(object()));
        case "documentType":
            return Optional.ofNullable(clazz.cast(documentType()));
        case "includeSourceFiles":
            return Optional.ofNullable(clazz.cast(includeSourceFiles()));
        case "includeRenditions":
            return Optional.ofNullable(clazz.cast(includeRenditions()));
        case "includeAllVersions":
            return Optional.ofNullable(clazz.cast(includeAllVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("object", OBJECT_FIELD);
        map.put("documentType", DOCUMENT_TYPE_FIELD);
        map.put("includeSourceFiles", INCLUDE_SOURCE_FILES_FIELD);
        map.put("includeRenditions", INCLUDE_RENDITIONS_FIELD);
        map.put("includeAllVersions", INCLUDE_ALL_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VeevaSourceProperties, T> g) {
        return obj -> g.apply((VeevaSourceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VeevaSourceProperties> {
        /**
         * <p>
         * The object specified in the Veeva flow source.
         * </p>
         * 
         * @param object
         *        The object specified in the Veeva flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * <p>
         * The document type specified in the Veeva document extract flow.
         * </p>
         * 
         * @param documentType
         *        The document type specified in the Veeva document extract flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * Boolean value to include source files in Veeva document extract flow.
         * </p>
         * 
         * @param includeSourceFiles
         *        Boolean value to include source files in Veeva document extract flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSourceFiles(Boolean includeSourceFiles);

        /**
         * <p>
         * Boolean value to include file renditions in Veeva document extract flow.
         * </p>
         * 
         * @param includeRenditions
         *        Boolean value to include file renditions in Veeva document extract flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRenditions(Boolean includeRenditions);

        /**
         * <p>
         * Boolean value to include All Versions of files in Veeva document extract flow.
         * </p>
         * 
         * @param includeAllVersions
         *        Boolean value to include All Versions of files in Veeva document extract flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllVersions(Boolean includeAllVersions);
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private String documentType;

        private Boolean includeSourceFiles;

        private Boolean includeRenditions;

        private Boolean includeAllVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(VeevaSourceProperties model) {
            object(model.object);
            documentType(model.documentType);
            includeSourceFiles(model.includeSourceFiles);
            includeRenditions(model.includeRenditions);
            includeAllVersions(model.includeAllVersions);
        }

        public final String getObject() {
            return object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final String getDocumentType() {
            return documentType;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        public final Boolean getIncludeSourceFiles() {
            return includeSourceFiles;
        }

        public final void setIncludeSourceFiles(Boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
        }

        @Override
        public final Builder includeSourceFiles(Boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
            return this;
        }

        public final Boolean getIncludeRenditions() {
            return includeRenditions;
        }

        public final void setIncludeRenditions(Boolean includeRenditions) {
            this.includeRenditions = includeRenditions;
        }

        @Override
        public final Builder includeRenditions(Boolean includeRenditions) {
            this.includeRenditions = includeRenditions;
            return this;
        }

        public final Boolean getIncludeAllVersions() {
            return includeAllVersions;
        }

        public final void setIncludeAllVersions(Boolean includeAllVersions) {
            this.includeAllVersions = includeAllVersions;
        }

        @Override
        public final Builder includeAllVersions(Boolean includeAllVersions) {
            this.includeAllVersions = includeAllVersions;
            return this;
        }

        @Override
        public VeevaSourceProperties build() {
            return new VeevaSourceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
