/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
 * </p>
 * <p>
 * For example, this setting would determine where to write the response from the destination connector upon a
 * successful insert operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuccessResponseHandlingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SuccessResponseHandlingConfig.Builder, SuccessResponseHandlingConfig> {
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(SuccessResponseHandlingConfig::bucketPrefix))
            .setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(SuccessResponseHandlingConfig::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_PREFIX_FIELD,
            BUCKET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketPrefix;

    private final String bucketName;

    private SuccessResponseHandlingConfig(BuilderImpl builder) {
        this.bucketPrefix = builder.bucketPrefix;
        this.bucketName = builder.bucketName;
    }

    /**
     * <p>
     * The Amazon S3 bucket prefix.
     * </p>
     * 
     * @return The Amazon S3 bucket prefix.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuccessResponseHandlingConfig)) {
            return false;
        }
        SuccessResponseHandlingConfig other = (SuccessResponseHandlingConfig) obj;
        return Objects.equals(bucketPrefix(), other.bucketPrefix()) && Objects.equals(bucketName(), other.bucketName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuccessResponseHandlingConfig").add("BucketPrefix", bucketPrefix())
                .add("BucketName", bucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketPrefix", BUCKET_PREFIX_FIELD);
        map.put("bucketName", BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuccessResponseHandlingConfig, T> g) {
        return obj -> g.apply((SuccessResponseHandlingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuccessResponseHandlingConfig> {
        /**
         * <p>
         * The Amazon S3 bucket prefix.
         * </p>
         * 
         * @param bucketPrefix
         *        The Amazon S3 bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The name of the Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The name of the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);
    }

    static final class BuilderImpl implements Builder {
        private String bucketPrefix;

        private String bucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(SuccessResponseHandlingConfig model) {
            bucketPrefix(model.bucketPrefix);
            bucketName(model.bucketName);
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Override
        public SuccessResponseHandlingConfig build() {
            return new SuccessResponseHandlingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
