/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelFlowExecutionsRequest extends AppflowRequest implements
        ToCopyableBuilder<CancelFlowExecutionsRequest.Builder, CancelFlowExecutionsRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(CancelFlowExecutionsRequest::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<List<String>> EXECUTION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("executionIds")
            .getter(getter(CancelFlowExecutionsRequest::executionIds))
            .setter(setter(Builder::executionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD,
            EXECUTION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flowName;

    private final List<String> executionIds;

    private CancelFlowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.executionIds = builder.executionIds;
    }

    /**
     * <p>
     * The name of a flow with active runs that you want to cancel.
     * </p>
     * 
     * @return The name of a flow with active runs that you want to cancel.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionIds() {
        return executionIds != null && !(executionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of each active run to cancel. These runs must belong to the flow you specify in your request.
     * </p>
     * <p>
     * If you omit this parameter, your request ends all active runs that belong to the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionIds} method.
     * </p>
     * 
     * @return The ID of each active run to cancel. These runs must belong to the flow you specify in your request.</p>
     *         <p>
     *         If you omit this parameter, your request ends all active runs that belong to the flow.
     */
    public final List<String> executionIds() {
        return executionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionIds() ? executionIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelFlowExecutionsRequest)) {
            return false;
        }
        CancelFlowExecutionsRequest other = (CancelFlowExecutionsRequest) obj;
        return Objects.equals(flowName(), other.flowName()) && hasExecutionIds() == other.hasExecutionIds()
                && Objects.equals(executionIds(), other.executionIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelFlowExecutionsRequest").add("FlowName", flowName())
                .add("ExecutionIds", hasExecutionIds() ? executionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "executionIds":
            return Optional.ofNullable(clazz.cast(executionIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowName", FLOW_NAME_FIELD);
        map.put("executionIds", EXECUTION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelFlowExecutionsRequest, T> g) {
        return obj -> g.apply((CancelFlowExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelFlowExecutionsRequest> {
        /**
         * <p>
         * The name of a flow with active runs that you want to cancel.
         * </p>
         * 
         * @param flowName
         *        The name of a flow with active runs that you want to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * The ID of each active run to cancel. These runs must belong to the flow you specify in your request.
         * </p>
         * <p>
         * If you omit this parameter, your request ends all active runs that belong to the flow.
         * </p>
         * 
         * @param executionIds
         *        The ID of each active run to cancel. These runs must belong to the flow you specify in your
         *        request.</p>
         *        <p>
         *        If you omit this parameter, your request ends all active runs that belong to the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionIds(Collection<String> executionIds);

        /**
         * <p>
         * The ID of each active run to cancel. These runs must belong to the flow you specify in your request.
         * </p>
         * <p>
         * If you omit this parameter, your request ends all active runs that belong to the flow.
         * </p>
         * 
         * @param executionIds
         *        The ID of each active run to cancel. These runs must belong to the flow you specify in your
         *        request.</p>
         *        <p>
         *        If you omit this parameter, your request ends all active runs that belong to the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionIds(String... executionIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String flowName;

        private List<String> executionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelFlowExecutionsRequest model) {
            super(model);
            flowName(model.flowName);
            executionIds(model.executionIds);
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final Collection<String> getExecutionIds() {
            if (executionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return executionIds;
        }

        public final void setExecutionIds(Collection<String> executionIds) {
            this.executionIds = ExecutionIdsCopier.copy(executionIds);
        }

        @Override
        public final Builder executionIds(Collection<String> executionIds) {
            this.executionIds = ExecutionIdsCopier.copy(executionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionIds(String... executionIds) {
            executionIds(Arrays.asList(executionIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelFlowExecutionsRequest build() {
            return new CancelFlowExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
