/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The API key credentials required for API key authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiKeyCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiKeyCredentials.Builder, ApiKeyCredentials> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiKey")
            .getter(getter(ApiKeyCredentials::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()).build();

    private static final SdkField<String> API_SECRET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiSecretKey").getter(getter(ApiKeyCredentials::apiSecretKey)).setter(setter(Builder::apiSecretKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSecretKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD,
            API_SECRET_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiKey;

    private final String apiSecretKey;

    private ApiKeyCredentials(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.apiSecretKey = builder.apiSecretKey;
    }

    /**
     * <p>
     * The API key required for API key authentication.
     * </p>
     * 
     * @return The API key required for API key authentication.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * The API secret key required for API key authentication.
     * </p>
     * 
     * @return The API secret key required for API key authentication.
     */
    public final String apiSecretKey() {
        return apiSecretKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(apiSecretKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiKeyCredentials)) {
            return false;
        }
        ApiKeyCredentials other = (ApiKeyCredentials) obj;
        return Objects.equals(apiKey(), other.apiKey()) && Objects.equals(apiSecretKey(), other.apiSecretKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiKeyCredentials").add("ApiKey", apiKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApiSecretKey", apiSecretKey() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "apiSecretKey":
            return Optional.ofNullable(clazz.cast(apiSecretKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiKey", API_KEY_FIELD);
        map.put("apiSecretKey", API_SECRET_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiKeyCredentials, T> g) {
        return obj -> g.apply((ApiKeyCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiKeyCredentials> {
        /**
         * <p>
         * The API key required for API key authentication.
         * </p>
         * 
         * @param apiKey
         *        The API key required for API key authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * The API secret key required for API key authentication.
         * </p>
         * 
         * @param apiSecretKey
         *        The API secret key required for API key authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSecretKey(String apiSecretKey);
    }

    static final class BuilderImpl implements Builder {
        private String apiKey;

        private String apiSecretKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiKeyCredentials model) {
            apiKey(model.apiKey);
            apiSecretKey(model.apiSecretKey);
        }

        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getApiSecretKey() {
            return apiSecretKey;
        }

        public final void setApiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
        }

        @Override
        public final Builder apiSecretKey(String apiSecretKey) {
            this.apiSecretKey = apiSecretKey;
            return this;
        }

        @Override
        public ApiKeyCredentials build() {
            return new ApiKeyCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
