/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningFailureCause;
import software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivateConnectionProvisioningState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivateConnectionProvisioningState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PrivateConnectionProvisioningState.getter(PrivateConnectionProvisioningState::statusAsString)).setter(PrivateConnectionProvisioningState.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(PrivateConnectionProvisioningState.getter(PrivateConnectionProvisioningState::failureMessage)).setter(PrivateConnectionProvisioningState.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<String> FAILURE_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCause").getter(PrivateConnectionProvisioningState.getter(PrivateConnectionProvisioningState::failureCauseAsString)).setter(PrivateConnectionProvisioningState.setter(Builder::failureCause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FAILURE_MESSAGE_FIELD, FAILURE_CAUSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrivateConnectionProvisioningState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String failureMessage;
    private final String failureCause;

    private PrivateConnectionProvisioningState(BuilderImpl builder) {
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.failureCause = builder.failureCause;
    }

    public final PrivateConnectionProvisioningStatus status() {
        return PrivateConnectionProvisioningStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final PrivateConnectionProvisioningFailureCause failureCause() {
        return PrivateConnectionProvisioningFailureCause.fromValue(this.failureCause);
    }

    public final String failureCauseAsString() {
        return this.failureCause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCauseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateConnectionProvisioningState)) {
            return false;
        }
        PrivateConnectionProvisioningState other = (PrivateConnectionProvisioningState)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.failureCauseAsString(), other.failureCauseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PrivateConnectionProvisioningState").add("Status", (Object)this.statusAsString()).add("FailureMessage", (Object)this.failureMessage()).add("FailureCause", (Object)this.failureCauseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "failureCause": {
                return Optional.ofNullable(clazz.cast(this.failureCauseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("failureCause", FAILURE_CAUSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateConnectionProvisioningState, T> g) {
        return obj -> g.apply((PrivateConnectionProvisioningState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String failureMessage;
        private String failureCause;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateConnectionProvisioningState model) {
            this.status(model.status);
            this.failureMessage(model.failureMessage);
            this.failureCause(model.failureCause);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PrivateConnectionProvisioningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getFailureCause() {
            return this.failureCause;
        }

        public final void setFailureCause(String failureCause) {
            this.failureCause = failureCause;
        }

        @Override
        public final Builder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        @Override
        public final Builder failureCause(PrivateConnectionProvisioningFailureCause failureCause) {
            this.failureCause(failureCause == null ? null : failureCause.toString());
            return this;
        }

        public PrivateConnectionProvisioningState build() {
            return new PrivateConnectionProvisioningState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivateConnectionProvisioningState> {
        public Builder status(String var1);

        public Builder status(PrivateConnectionProvisioningStatus var1);

        public Builder failureMessage(String var1);

        public Builder failureCause(String var1);

        public Builder failureCause(PrivateConnectionProvisioningFailureCause var1);
    }
}

