/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceFieldProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceFieldProperties> {
    private static final SdkField<Boolean> IS_RETRIEVABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRetrievable").getter(SourceFieldProperties.getter(SourceFieldProperties::isRetrievable)).setter(SourceFieldProperties.setter(Builder::isRetrievable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRetrievable").build()}).build();
    private static final SdkField<Boolean> IS_QUERYABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isQueryable").getter(SourceFieldProperties.getter(SourceFieldProperties::isQueryable)).setter(SourceFieldProperties.setter(Builder::isQueryable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isQueryable").build()}).build();
    private static final SdkField<Boolean> IS_TIMESTAMP_FIELD_FOR_INCREMENTAL_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTimestampFieldForIncrementalQueries").getter(SourceFieldProperties.getter(SourceFieldProperties::isTimestampFieldForIncrementalQueries)).setter(SourceFieldProperties.setter(Builder::isTimestampFieldForIncrementalQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTimestampFieldForIncrementalQueries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_RETRIEVABLE_FIELD, IS_QUERYABLE_FIELD, IS_TIMESTAMP_FIELD_FOR_INCREMENTAL_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceFieldProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isRetrievable;
    private final Boolean isQueryable;
    private final Boolean isTimestampFieldForIncrementalQueries;

    private SourceFieldProperties(BuilderImpl builder) {
        this.isRetrievable = builder.isRetrievable;
        this.isQueryable = builder.isQueryable;
        this.isTimestampFieldForIncrementalQueries = builder.isTimestampFieldForIncrementalQueries;
    }

    public final Boolean isRetrievable() {
        return this.isRetrievable;
    }

    public final Boolean isQueryable() {
        return this.isQueryable;
    }

    public final Boolean isTimestampFieldForIncrementalQueries() {
        return this.isTimestampFieldForIncrementalQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isRetrievable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isQueryable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTimestampFieldForIncrementalQueries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFieldProperties)) {
            return false;
        }
        SourceFieldProperties other = (SourceFieldProperties)obj;
        return Objects.equals(this.isRetrievable(), other.isRetrievable()) && Objects.equals(this.isQueryable(), other.isQueryable()) && Objects.equals(this.isTimestampFieldForIncrementalQueries(), other.isTimestampFieldForIncrementalQueries());
    }

    public final String toString() {
        return ToString.builder((String)"SourceFieldProperties").add("IsRetrievable", (Object)this.isRetrievable()).add("IsQueryable", (Object)this.isQueryable()).add("IsTimestampFieldForIncrementalQueries", (Object)this.isTimestampFieldForIncrementalQueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isRetrievable": {
                return Optional.ofNullable(clazz.cast(this.isRetrievable()));
            }
            case "isQueryable": {
                return Optional.ofNullable(clazz.cast(this.isQueryable()));
            }
            case "isTimestampFieldForIncrementalQueries": {
                return Optional.ofNullable(clazz.cast(this.isTimestampFieldForIncrementalQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("isRetrievable", IS_RETRIEVABLE_FIELD);
        map.put("isQueryable", IS_QUERYABLE_FIELD);
        map.put("isTimestampFieldForIncrementalQueries", IS_TIMESTAMP_FIELD_FOR_INCREMENTAL_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceFieldProperties, T> g) {
        return obj -> g.apply((SourceFieldProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isRetrievable;
        private Boolean isQueryable;
        private Boolean isTimestampFieldForIncrementalQueries;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFieldProperties model) {
            this.isRetrievable(model.isRetrievable);
            this.isQueryable(model.isQueryable);
            this.isTimestampFieldForIncrementalQueries(model.isTimestampFieldForIncrementalQueries);
        }

        public final Boolean getIsRetrievable() {
            return this.isRetrievable;
        }

        public final void setIsRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
        }

        @Override
        public final Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            return this;
        }

        public final Boolean getIsQueryable() {
            return this.isQueryable;
        }

        public final void setIsQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
        }

        @Override
        public final Builder isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            return this;
        }

        public final Boolean getIsTimestampFieldForIncrementalQueries() {
            return this.isTimestampFieldForIncrementalQueries;
        }

        public final void setIsTimestampFieldForIncrementalQueries(Boolean isTimestampFieldForIncrementalQueries) {
            this.isTimestampFieldForIncrementalQueries = isTimestampFieldForIncrementalQueries;
        }

        @Override
        public final Builder isTimestampFieldForIncrementalQueries(Boolean isTimestampFieldForIncrementalQueries) {
            this.isTimestampFieldForIncrementalQueries = isTimestampFieldForIncrementalQueries;
            return this;
        }

        public SourceFieldProperties build() {
            return new SourceFieldProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceFieldProperties> {
        public Builder isRetrievable(Boolean var1);

        public Builder isQueryable(Boolean var1);

        public Builder isTimestampFieldForIncrementalQueries(Boolean var1);
    }
}

