/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAPODataPaginationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAPODataPaginationConfig> {
    private static final SdkField<Integer> MAX_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxPageSize").getter(SAPODataPaginationConfig.getter(SAPODataPaginationConfig::maxPageSize)).setter(SAPODataPaginationConfig.setter(Builder::maxPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_PAGE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SAPODataPaginationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxPageSize;

    private SAPODataPaginationConfig(BuilderImpl builder) {
        this.maxPageSize = builder.maxPageSize;
    }

    public final Integer maxPageSize() {
        return this.maxPageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataPaginationConfig)) {
            return false;
        }
        SAPODataPaginationConfig other = (SAPODataPaginationConfig)obj;
        return Objects.equals(this.maxPageSize(), other.maxPageSize());
    }

    public final String toString() {
        return ToString.builder((String)"SAPODataPaginationConfig").add("MaxPageSize", (Object)this.maxPageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxPageSize": {
                return Optional.ofNullable(clazz.cast(this.maxPageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("maxPageSize", MAX_PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAPODataPaginationConfig, T> g) {
        return obj -> g.apply((SAPODataPaginationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxPageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataPaginationConfig model) {
            this.maxPageSize(model.maxPageSize);
        }

        public final Integer getMaxPageSize() {
            return this.maxPageSize;
        }

        public final void setMaxPageSize(Integer maxPageSize) {
            this.maxPageSize = maxPageSize;
        }

        @Override
        public final Builder maxPageSize(Integer maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public SAPODataPaginationConfig build() {
            return new SAPODataPaginationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAPODataPaginationConfig> {
        public Builder maxPageSize(Integer var1);
    }
}

