/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorProfileNameListCopier;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorProfilesRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, DescribeConnectorProfilesRequest> {
    private static final SdkField<List<String>> CONNECTOR_PROFILE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorProfileNames").getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::connectorProfileNames)).setter(DescribeConnectorProfilesRequest.setter(Builder::connectorProfileNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::connectorTypeAsString)).setter(DescribeConnectorProfilesRequest.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorLabel").getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::connectorLabel)).setter(DescribeConnectorProfilesRequest.setter(Builder::connectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::maxResults)).setter(DescribeConnectorProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeConnectorProfilesRequest.getter(DescribeConnectorProfilesRequest::nextToken)).setter(DescribeConnectorProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAMES_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConnectorProfilesRequest.memberNameToFieldInitializer();
    private final List<String> connectorProfileNames;
    private final String connectorType;
    private final String connectorLabel;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeConnectorProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileNames = builder.connectorProfileNames;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectorProfileNames() {
        return this.connectorProfileNames != null && !(this.connectorProfileNames instanceof SdkAutoConstructList);
    }

    public final List<String> connectorProfileNames() {
        return this.connectorProfileNames;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorLabel() {
        return this.connectorLabel;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorProfileNames() ? this.connectorProfileNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorProfilesRequest)) {
            return false;
        }
        DescribeConnectorProfilesRequest other = (DescribeConnectorProfilesRequest)((Object)obj);
        return this.hasConnectorProfileNames() == other.hasConnectorProfileNames() && Objects.equals(this.connectorProfileNames(), other.connectorProfileNames()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorLabel(), other.connectorLabel()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorProfilesRequest").add("ConnectorProfileNames", this.hasConnectorProfileNames() ? this.connectorProfileNames() : null).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorLabel", (Object)this.connectorLabel()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorProfileNames": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileNames()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorLabel": {
                return Optional.ofNullable(clazz.cast(this.connectorLabel()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorProfileNames", CONNECTOR_PROFILE_NAMES_FIELD);
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("connectorLabel", CONNECTOR_LABEL_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorProfilesRequest, T> g) {
        return obj -> g.apply((DescribeConnectorProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private List<String> connectorProfileNames = DefaultSdkAutoConstructList.getInstance();
        private String connectorType;
        private String connectorLabel;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorProfilesRequest model) {
            super(model);
            this.connectorProfileNames(model.connectorProfileNames);
            this.connectorType(model.connectorType);
            this.connectorLabel(model.connectorLabel);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConnectorProfileNames() {
            if (this.connectorProfileNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorProfileNames;
        }

        public final void setConnectorProfileNames(Collection<String> connectorProfileNames) {
            this.connectorProfileNames = ConnectorProfileNameListCopier.copy(connectorProfileNames);
        }

        @Override
        public final Builder connectorProfileNames(Collection<String> connectorProfileNames) {
            this.connectorProfileNames = ConnectorProfileNameListCopier.copy(connectorProfileNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorProfileNames(String ... connectorProfileNames) {
            this.connectorProfileNames(Arrays.asList(connectorProfileNames));
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return this.connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorProfilesRequest build() {
            return new DescribeConnectorProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorProfilesRequest> {
        public Builder connectorProfileNames(Collection<String> var1);

        public Builder connectorProfileNames(String ... var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorLabel(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

