/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.ConnectorDetail;
import software.amazon.awssdk.services.appflow.model.ConnectorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectorsResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, ListConnectorsResponse> {
    private static final SdkField<List<ConnectorDetail>> CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectors").getter(ListConnectorsResponse.getter(ListConnectorsResponse::connectors)).setter(ListConnectorsResponse.setter(Builder::connectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConnectorsResponse.getter(ListConnectorsResponse::nextToken)).setter(ListConnectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectorsResponse.memberNameToFieldInitializer();
    private final List<ConnectorDetail> connectors;
    private final String nextToken;

    private ListConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectors = builder.connectors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectors() {
        return this.connectors != null && !(this.connectors instanceof SdkAutoConstructList);
    }

    public final List<ConnectorDetail> connectors() {
        return this.connectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectors() ? this.connectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorsResponse)) {
            return false;
        }
        ListConnectorsResponse other = (ListConnectorsResponse)((Object)obj);
        return this.hasConnectors() == other.hasConnectors() && Objects.equals(this.connectors(), other.connectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectorsResponse").add("Connectors", this.hasConnectors() ? this.connectors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectors": {
                return Optional.ofNullable(clazz.cast(this.connectors()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectors", CONNECTORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorsResponse, T> g) {
        return obj -> g.apply((ListConnectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private List<ConnectorDetail> connectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorsResponse model) {
            super(model);
            this.connectors(model.connectors);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectorDetail.Builder> getConnectors() {
            List<ConnectorDetail.Builder> result = ConnectorListCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<ConnectorDetail.BuilderImpl> connectors) {
            this.connectors = ConnectorListCopier.copyFromBuilder(connectors);
        }

        @Override
        public final Builder connectors(Collection<ConnectorDetail> connectors) {
            this.connectors = ConnectorListCopier.copy(connectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(ConnectorDetail ... connectors) {
            this.connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Consumer<ConnectorDetail.Builder> ... connectors) {
            this.connectors(Stream.of(connectors).map(c -> (ConnectorDetail)((ConnectorDetail.Builder)ConnectorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectorsResponse build() {
            return new ListConnectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectorsResponse> {
        public Builder connectors(Collection<ConnectorDetail> var1);

        public Builder connectors(ConnectorDetail ... var1);

        public Builder connectors(Consumer<ConnectorDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

