/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.OAuthProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAPODataConnectorProfileProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAPODataConnectorProfileProperties> {
    private static final SdkField<String> APPLICATION_HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationHostUrl").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::applicationHostUrl)).setter(SAPODataConnectorProfileProperties.setter(Builder::applicationHostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationHostUrl").build()}).build();
    private static final SdkField<String> APPLICATION_SERVICE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationServicePath").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::applicationServicePath)).setter(SAPODataConnectorProfileProperties.setter(Builder::applicationServicePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationServicePath").build()}).build();
    private static final SdkField<Integer> PORT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("portNumber").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::portNumber)).setter(SAPODataConnectorProfileProperties.setter(Builder::portNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portNumber").build()}).build();
    private static final SdkField<String> CLIENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientNumber").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::clientNumber)).setter(SAPODataConnectorProfileProperties.setter(Builder::clientNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientNumber").build()}).build();
    private static final SdkField<String> LOGON_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logonLanguage").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::logonLanguage)).setter(SAPODataConnectorProfileProperties.setter(Builder::logonLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logonLanguage").build()}).build();
    private static final SdkField<String> PRIVATE_LINK_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateLinkServiceName").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::privateLinkServiceName)).setter(SAPODataConnectorProfileProperties.setter(Builder::privateLinkServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateLinkServiceName").build()}).build();
    private static final SdkField<OAuthProperties> O_AUTH_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuthProperties").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::oAuthProperties)).setter(SAPODataConnectorProfileProperties.setter(Builder::oAuthProperties)).constructor(OAuthProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthProperties").build()}).build();
    private static final SdkField<Boolean> DISABLE_SSO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disableSSO").getter(SAPODataConnectorProfileProperties.getter(SAPODataConnectorProfileProperties::disableSSO)).setter(SAPODataConnectorProfileProperties.setter(Builder::disableSSO)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSSO").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_HOST_URL_FIELD, APPLICATION_SERVICE_PATH_FIELD, PORT_NUMBER_FIELD, CLIENT_NUMBER_FIELD, LOGON_LANGUAGE_FIELD, PRIVATE_LINK_SERVICE_NAME_FIELD, O_AUTH_PROPERTIES_FIELD, DISABLE_SSO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SAPODataConnectorProfileProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationHostUrl;
    private final String applicationServicePath;
    private final Integer portNumber;
    private final String clientNumber;
    private final String logonLanguage;
    private final String privateLinkServiceName;
    private final OAuthProperties oAuthProperties;
    private final Boolean disableSSO;

    private SAPODataConnectorProfileProperties(BuilderImpl builder) {
        this.applicationHostUrl = builder.applicationHostUrl;
        this.applicationServicePath = builder.applicationServicePath;
        this.portNumber = builder.portNumber;
        this.clientNumber = builder.clientNumber;
        this.logonLanguage = builder.logonLanguage;
        this.privateLinkServiceName = builder.privateLinkServiceName;
        this.oAuthProperties = builder.oAuthProperties;
        this.disableSSO = builder.disableSSO;
    }

    public final String applicationHostUrl() {
        return this.applicationHostUrl;
    }

    public final String applicationServicePath() {
        return this.applicationServicePath;
    }

    public final Integer portNumber() {
        return this.portNumber;
    }

    public final String clientNumber() {
        return this.clientNumber;
    }

    public final String logonLanguage() {
        return this.logonLanguage;
    }

    public final String privateLinkServiceName() {
        return this.privateLinkServiceName;
    }

    public final OAuthProperties oAuthProperties() {
        return this.oAuthProperties;
    }

    public final Boolean disableSSO() {
        return this.disableSSO;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationHostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationServicePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.portNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.logonLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateLinkServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableSSO());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataConnectorProfileProperties)) {
            return false;
        }
        SAPODataConnectorProfileProperties other = (SAPODataConnectorProfileProperties)obj;
        return Objects.equals(this.applicationHostUrl(), other.applicationHostUrl()) && Objects.equals(this.applicationServicePath(), other.applicationServicePath()) && Objects.equals(this.portNumber(), other.portNumber()) && Objects.equals(this.clientNumber(), other.clientNumber()) && Objects.equals(this.logonLanguage(), other.logonLanguage()) && Objects.equals(this.privateLinkServiceName(), other.privateLinkServiceName()) && Objects.equals(this.oAuthProperties(), other.oAuthProperties()) && Objects.equals(this.disableSSO(), other.disableSSO());
    }

    public final String toString() {
        return ToString.builder((String)"SAPODataConnectorProfileProperties").add("ApplicationHostUrl", (Object)this.applicationHostUrl()).add("ApplicationServicePath", (Object)this.applicationServicePath()).add("PortNumber", (Object)this.portNumber()).add("ClientNumber", (Object)this.clientNumber()).add("LogonLanguage", (Object)this.logonLanguage()).add("PrivateLinkServiceName", (Object)this.privateLinkServiceName()).add("OAuthProperties", (Object)this.oAuthProperties()).add("DisableSSO", (Object)this.disableSSO()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationHostUrl": {
                return Optional.ofNullable(clazz.cast(this.applicationHostUrl()));
            }
            case "applicationServicePath": {
                return Optional.ofNullable(clazz.cast(this.applicationServicePath()));
            }
            case "portNumber": {
                return Optional.ofNullable(clazz.cast(this.portNumber()));
            }
            case "clientNumber": {
                return Optional.ofNullable(clazz.cast(this.clientNumber()));
            }
            case "logonLanguage": {
                return Optional.ofNullable(clazz.cast(this.logonLanguage()));
            }
            case "privateLinkServiceName": {
                return Optional.ofNullable(clazz.cast(this.privateLinkServiceName()));
            }
            case "oAuthProperties": {
                return Optional.ofNullable(clazz.cast(this.oAuthProperties()));
            }
            case "disableSSO": {
                return Optional.ofNullable(clazz.cast(this.disableSSO()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationHostUrl", APPLICATION_HOST_URL_FIELD);
        map.put("applicationServicePath", APPLICATION_SERVICE_PATH_FIELD);
        map.put("portNumber", PORT_NUMBER_FIELD);
        map.put("clientNumber", CLIENT_NUMBER_FIELD);
        map.put("logonLanguage", LOGON_LANGUAGE_FIELD);
        map.put("privateLinkServiceName", PRIVATE_LINK_SERVICE_NAME_FIELD);
        map.put("oAuthProperties", O_AUTH_PROPERTIES_FIELD);
        map.put("disableSSO", DISABLE_SSO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAPODataConnectorProfileProperties, T> g) {
        return obj -> g.apply((SAPODataConnectorProfileProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationHostUrl;
        private String applicationServicePath;
        private Integer portNumber;
        private String clientNumber;
        private String logonLanguage;
        private String privateLinkServiceName;
        private OAuthProperties oAuthProperties;
        private Boolean disableSSO;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataConnectorProfileProperties model) {
            this.applicationHostUrl(model.applicationHostUrl);
            this.applicationServicePath(model.applicationServicePath);
            this.portNumber(model.portNumber);
            this.clientNumber(model.clientNumber);
            this.logonLanguage(model.logonLanguage);
            this.privateLinkServiceName(model.privateLinkServiceName);
            this.oAuthProperties(model.oAuthProperties);
            this.disableSSO(model.disableSSO);
        }

        public final String getApplicationHostUrl() {
            return this.applicationHostUrl;
        }

        public final void setApplicationHostUrl(String applicationHostUrl) {
            this.applicationHostUrl = applicationHostUrl;
        }

        @Override
        public final Builder applicationHostUrl(String applicationHostUrl) {
            this.applicationHostUrl = applicationHostUrl;
            return this;
        }

        public final String getApplicationServicePath() {
            return this.applicationServicePath;
        }

        public final void setApplicationServicePath(String applicationServicePath) {
            this.applicationServicePath = applicationServicePath;
        }

        @Override
        public final Builder applicationServicePath(String applicationServicePath) {
            this.applicationServicePath = applicationServicePath;
            return this;
        }

        public final Integer getPortNumber() {
            return this.portNumber;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final String getClientNumber() {
            return this.clientNumber;
        }

        public final void setClientNumber(String clientNumber) {
            this.clientNumber = clientNumber;
        }

        @Override
        public final Builder clientNumber(String clientNumber) {
            this.clientNumber = clientNumber;
            return this;
        }

        public final String getLogonLanguage() {
            return this.logonLanguage;
        }

        public final void setLogonLanguage(String logonLanguage) {
            this.logonLanguage = logonLanguage;
        }

        @Override
        public final Builder logonLanguage(String logonLanguage) {
            this.logonLanguage = logonLanguage;
            return this;
        }

        public final String getPrivateLinkServiceName() {
            return this.privateLinkServiceName;
        }

        public final void setPrivateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
        }

        @Override
        public final Builder privateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
            return this;
        }

        public final OAuthProperties.Builder getOAuthProperties() {
            return this.oAuthProperties != null ? this.oAuthProperties.toBuilder() : null;
        }

        public final void setOAuthProperties(OAuthProperties.BuilderImpl oAuthProperties) {
            this.oAuthProperties = oAuthProperties != null ? oAuthProperties.build() : null;
        }

        @Override
        public final Builder oAuthProperties(OAuthProperties oAuthProperties) {
            this.oAuthProperties = oAuthProperties;
            return this;
        }

        public final Boolean getDisableSSO() {
            return this.disableSSO;
        }

        public final void setDisableSSO(Boolean disableSSO) {
            this.disableSSO = disableSSO;
        }

        @Override
        public final Builder disableSSO(Boolean disableSSO) {
            this.disableSSO = disableSSO;
            return this;
        }

        public SAPODataConnectorProfileProperties build() {
            return new SAPODataConnectorProfileProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAPODataConnectorProfileProperties> {
        public Builder applicationHostUrl(String var1);

        public Builder applicationServicePath(String var1);

        public Builder portNumber(Integer var1);

        public Builder clientNumber(String var1);

        public Builder logonLanguage(String var1);

        public Builder privateLinkServiceName(String var1);

        public Builder oAuthProperties(OAuthProperties var1);

        default public Builder oAuthProperties(Consumer<OAuthProperties.Builder> oAuthProperties) {
            return this.oAuthProperties((OAuthProperties)((OAuthProperties.Builder)OAuthProperties.builder().applyMutation(oAuthProperties)).build());
        }

        public Builder disableSSO(Boolean var1);
    }
}

