/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VeevaSourceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VeevaSourceProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("object").getter(VeevaSourceProperties.getter(VeevaSourceProperties::object)).setter(VeevaSourceProperties.setter(Builder::object)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentType").getter(VeevaSourceProperties.getter(VeevaSourceProperties::documentType)).setter(VeevaSourceProperties.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentType").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SOURCE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeSourceFiles").getter(VeevaSourceProperties.getter(VeevaSourceProperties::includeSourceFiles)).setter(VeevaSourceProperties.setter(Builder::includeSourceFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSourceFiles").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RENDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeRenditions").getter(VeevaSourceProperties.getter(VeevaSourceProperties::includeRenditions)).setter(VeevaSourceProperties.setter(Builder::includeRenditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeRenditions").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeAllVersions").getter(VeevaSourceProperties.getter(VeevaSourceProperties::includeAllVersions)).setter(VeevaSourceProperties.setter(Builder::includeAllVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAllVersions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD, DOCUMENT_TYPE_FIELD, INCLUDE_SOURCE_FILES_FIELD, INCLUDE_RENDITIONS_FIELD, INCLUDE_ALL_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VeevaSourceProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String object;
    private final String documentType;
    private final Boolean includeSourceFiles;
    private final Boolean includeRenditions;
    private final Boolean includeAllVersions;

    private VeevaSourceProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.documentType = builder.documentType;
        this.includeSourceFiles = builder.includeSourceFiles;
        this.includeRenditions = builder.includeRenditions;
        this.includeAllVersions = builder.includeAllVersions;
    }

    public final String object() {
        return this.object;
    }

    public final String documentType() {
        return this.documentType;
    }

    public final Boolean includeSourceFiles() {
        return this.includeSourceFiles;
    }

    public final Boolean includeRenditions() {
        return this.includeRenditions;
    }

    public final Boolean includeAllVersions() {
        return this.includeAllVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.object());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSourceFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeRenditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllVersions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VeevaSourceProperties)) {
            return false;
        }
        VeevaSourceProperties other = (VeevaSourceProperties)obj;
        return Objects.equals(this.object(), other.object()) && Objects.equals(this.documentType(), other.documentType()) && Objects.equals(this.includeSourceFiles(), other.includeSourceFiles()) && Objects.equals(this.includeRenditions(), other.includeRenditions()) && Objects.equals(this.includeAllVersions(), other.includeAllVersions());
    }

    public final String toString() {
        return ToString.builder((String)"VeevaSourceProperties").add("Object", (Object)this.object()).add("DocumentType", (Object)this.documentType()).add("IncludeSourceFiles", (Object)this.includeSourceFiles()).add("IncludeRenditions", (Object)this.includeRenditions()).add("IncludeAllVersions", (Object)this.includeAllVersions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "object": {
                return Optional.ofNullable(clazz.cast(this.object()));
            }
            case "documentType": {
                return Optional.ofNullable(clazz.cast(this.documentType()));
            }
            case "includeSourceFiles": {
                return Optional.ofNullable(clazz.cast(this.includeSourceFiles()));
            }
            case "includeRenditions": {
                return Optional.ofNullable(clazz.cast(this.includeRenditions()));
            }
            case "includeAllVersions": {
                return Optional.ofNullable(clazz.cast(this.includeAllVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("object", OBJECT_FIELD);
        map.put("documentType", DOCUMENT_TYPE_FIELD);
        map.put("includeSourceFiles", INCLUDE_SOURCE_FILES_FIELD);
        map.put("includeRenditions", INCLUDE_RENDITIONS_FIELD);
        map.put("includeAllVersions", INCLUDE_ALL_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VeevaSourceProperties, T> g) {
        return obj -> g.apply((VeevaSourceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String object;
        private String documentType;
        private Boolean includeSourceFiles;
        private Boolean includeRenditions;
        private Boolean includeAllVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(VeevaSourceProperties model) {
            this.object(model.object);
            this.documentType(model.documentType);
            this.includeSourceFiles(model.includeSourceFiles);
            this.includeRenditions(model.includeRenditions);
            this.includeAllVersions(model.includeAllVersions);
        }

        public final String getObject() {
            return this.object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        public final Boolean getIncludeSourceFiles() {
            return this.includeSourceFiles;
        }

        public final void setIncludeSourceFiles(Boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
        }

        @Override
        public final Builder includeSourceFiles(Boolean includeSourceFiles) {
            this.includeSourceFiles = includeSourceFiles;
            return this;
        }

        public final Boolean getIncludeRenditions() {
            return this.includeRenditions;
        }

        public final void setIncludeRenditions(Boolean includeRenditions) {
            this.includeRenditions = includeRenditions;
        }

        @Override
        public final Builder includeRenditions(Boolean includeRenditions) {
            this.includeRenditions = includeRenditions;
            return this;
        }

        public final Boolean getIncludeAllVersions() {
            return this.includeAllVersions;
        }

        public final void setIncludeAllVersions(Boolean includeAllVersions) {
            this.includeAllVersions = includeAllVersions;
        }

        @Override
        public final Builder includeAllVersions(Boolean includeAllVersions) {
            this.includeAllVersions = includeAllVersions;
            return this;
        }

        public VeevaSourceProperties build() {
            return new VeevaSourceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VeevaSourceProperties> {
        public Builder object(String var1);

        public Builder documentType(String var1);

        public Builder includeSourceFiles(Boolean var1);

        public Builder includeRenditions(Boolean var1);

        public Builder includeAllVersions(Boolean var1);
    }
}

