/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.ExecutionIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelFlowExecutionsResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, CancelFlowExecutionsResponse> {
    private static final SdkField<List<String>> INVALID_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invalidExecutions").getter(CancelFlowExecutionsResponse.getter(CancelFlowExecutionsResponse::invalidExecutions)).setter(CancelFlowExecutionsResponse.setter(Builder::invalidExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_EXECUTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelFlowExecutionsResponse.memberNameToFieldInitializer();
    private final List<String> invalidExecutions;

    private CancelFlowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.invalidExecutions = builder.invalidExecutions;
    }

    public final boolean hasInvalidExecutions() {
        return this.invalidExecutions != null && !(this.invalidExecutions instanceof SdkAutoConstructList);
    }

    public final List<String> invalidExecutions() {
        return this.invalidExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidExecutions() ? this.invalidExecutions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelFlowExecutionsResponse)) {
            return false;
        }
        CancelFlowExecutionsResponse other = (CancelFlowExecutionsResponse)((Object)obj);
        return this.hasInvalidExecutions() == other.hasInvalidExecutions() && Objects.equals(this.invalidExecutions(), other.invalidExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"CancelFlowExecutionsResponse").add("InvalidExecutions", this.hasInvalidExecutions() ? this.invalidExecutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invalidExecutions": {
                return Optional.ofNullable(clazz.cast(this.invalidExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("invalidExecutions", INVALID_EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelFlowExecutionsResponse, T> g) {
        return obj -> g.apply((CancelFlowExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private List<String> invalidExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelFlowExecutionsResponse model) {
            super(model);
            this.invalidExecutions(model.invalidExecutions);
        }

        public final Collection<String> getInvalidExecutions() {
            if (this.invalidExecutions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invalidExecutions;
        }

        public final void setInvalidExecutions(Collection<String> invalidExecutions) {
            this.invalidExecutions = ExecutionIdsCopier.copy(invalidExecutions);
        }

        @Override
        public final Builder invalidExecutions(Collection<String> invalidExecutions) {
            this.invalidExecutions = ExecutionIdsCopier.copy(invalidExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidExecutions(String ... invalidExecutions) {
            this.invalidExecutions(Arrays.asList(invalidExecutions));
            return this;
        }

        @Override
        public CancelFlowExecutionsResponse build() {
            return new CancelFlowExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelFlowExecutionsResponse> {
        public Builder invalidExecutions(Collection<String> var1);

        public Builder invalidExecutions(String ... var1);
    }
}

