/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.ConnectorSuppliedValueListCopier;
import software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2CustomParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2CustomParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::key)).setter(OAuth2CustomParameter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRequired").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::isRequired)).setter(OAuth2CustomParameter.setter(Builder::isRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequired").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("label").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::label)).setter(OAuth2CustomParameter.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::description)).setter(OAuth2CustomParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_SENSITIVE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSensitiveField").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::isSensitiveField)).setter(OAuth2CustomParameter.setter(Builder::isSensitiveField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSensitiveField").build()}).build();
    private static final SdkField<List<String>> CONNECTOR_SUPPLIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorSuppliedValues").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::connectorSuppliedValues)).setter(OAuth2CustomParameter.setter(Builder::connectorSuppliedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSuppliedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(OAuth2CustomParameter.getter(OAuth2CustomParameter::typeAsString)).setter(OAuth2CustomParameter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, IS_REQUIRED_FIELD, LABEL_FIELD, DESCRIPTION_FIELD, IS_SENSITIVE_FIELD_FIELD, CONNECTOR_SUPPLIED_VALUES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuth2CustomParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final Boolean isRequired;
    private final String label;
    private final String description;
    private final Boolean isSensitiveField;
    private final List<String> connectorSuppliedValues;
    private final String type;

    private OAuth2CustomParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.isRequired = builder.isRequired;
        this.label = builder.label;
        this.description = builder.description;
        this.isSensitiveField = builder.isSensitiveField;
        this.connectorSuppliedValues = builder.connectorSuppliedValues;
        this.type = builder.type;
    }

    public final String key() {
        return this.key;
    }

    public final Boolean isRequired() {
        return this.isRequired;
    }

    public final String label() {
        return this.label;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isSensitiveField() {
        return this.isSensitiveField;
    }

    public final boolean hasConnectorSuppliedValues() {
        return this.connectorSuppliedValues != null && !(this.connectorSuppliedValues instanceof SdkAutoConstructList);
    }

    public final List<String> connectorSuppliedValues() {
        return this.connectorSuppliedValues;
    }

    public final OAuth2CustomPropType type() {
        return OAuth2CustomPropType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSensitiveField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorSuppliedValues() ? this.connectorSuppliedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2CustomParameter)) {
            return false;
        }
        OAuth2CustomParameter other = (OAuth2CustomParameter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.isRequired(), other.isRequired()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isSensitiveField(), other.isSensitiveField()) && this.hasConnectorSuppliedValues() == other.hasConnectorSuppliedValues() && Objects.equals(this.connectorSuppliedValues(), other.connectorSuppliedValues()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2CustomParameter").add("Key", (Object)this.key()).add("IsRequired", (Object)this.isRequired()).add("Label", (Object)this.label()).add("Description", (Object)this.description()).add("IsSensitiveField", (Object)this.isSensitiveField()).add("ConnectorSuppliedValues", this.hasConnectorSuppliedValues() ? this.connectorSuppliedValues() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "isRequired": {
                return Optional.ofNullable(clazz.cast(this.isRequired()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isSensitiveField": {
                return Optional.ofNullable(clazz.cast(this.isSensitiveField()));
            }
            case "connectorSuppliedValues": {
                return Optional.ofNullable(clazz.cast(this.connectorSuppliedValues()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("isRequired", IS_REQUIRED_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isSensitiveField", IS_SENSITIVE_FIELD_FIELD);
        map.put("connectorSuppliedValues", CONNECTOR_SUPPLIED_VALUES_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2CustomParameter, T> g) {
        return obj -> g.apply((OAuth2CustomParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private Boolean isRequired;
        private String label;
        private String description;
        private Boolean isSensitiveField;
        private List<String> connectorSuppliedValues = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2CustomParameter model) {
            this.key(model.key);
            this.isRequired(model.isRequired);
            this.label(model.label);
            this.description(model.description);
            this.isSensitiveField(model.isSensitiveField);
            this.connectorSuppliedValues(model.connectorSuppliedValues);
            this.type(model.type);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Boolean getIsRequired() {
            return this.isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsSensitiveField() {
            return this.isSensitiveField;
        }

        public final void setIsSensitiveField(Boolean isSensitiveField) {
            this.isSensitiveField = isSensitiveField;
        }

        @Override
        public final Builder isSensitiveField(Boolean isSensitiveField) {
            this.isSensitiveField = isSensitiveField;
            return this;
        }

        public final Collection<String> getConnectorSuppliedValues() {
            if (this.connectorSuppliedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorSuppliedValues;
        }

        public final void setConnectorSuppliedValues(Collection<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = ConnectorSuppliedValueListCopier.copy(connectorSuppliedValues);
        }

        @Override
        public final Builder connectorSuppliedValues(Collection<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = ConnectorSuppliedValueListCopier.copy(connectorSuppliedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorSuppliedValues(String ... connectorSuppliedValues) {
            this.connectorSuppliedValues(Arrays.asList(connectorSuppliedValues));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OAuth2CustomPropType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public OAuth2CustomParameter build() {
            return new OAuth2CustomParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2CustomParameter> {
        public Builder key(String var1);

        public Builder isRequired(Boolean var1);

        public Builder label(String var1);

        public Builder description(String var1);

        public Builder isSensitiveField(Boolean var1);

        public Builder connectorSuppliedValues(Collection<String> var1);

        public Builder connectorSuppliedValues(String ... var1);

        public Builder type(String var1);

        public Builder type(OAuth2CustomPropType var1);
    }
}

