/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.ConnectorSuppliedValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(AuthParameter.getter(AuthParameter::key)).setter(AuthParameter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRequired").getter(AuthParameter.getter(AuthParameter::isRequired)).setter(AuthParameter.setter(Builder::isRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequired").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("label").getter(AuthParameter.getter(AuthParameter::label)).setter(AuthParameter.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AuthParameter.getter(AuthParameter::description)).setter(AuthParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_SENSITIVE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSensitiveField").getter(AuthParameter.getter(AuthParameter::isSensitiveField)).setter(AuthParameter.setter(Builder::isSensitiveField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSensitiveField").build()}).build();
    private static final SdkField<List<String>> CONNECTOR_SUPPLIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorSuppliedValues").getter(AuthParameter.getter(AuthParameter::connectorSuppliedValues)).setter(AuthParameter.setter(Builder::connectorSuppliedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSuppliedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, IS_REQUIRED_FIELD, LABEL_FIELD, DESCRIPTION_FIELD, IS_SENSITIVE_FIELD_FIELD, CONNECTOR_SUPPLIED_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("key", KEY_FIELD);
            this.put("isRequired", IS_REQUIRED_FIELD);
            this.put("label", LABEL_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("isSensitiveField", IS_SENSITIVE_FIELD_FIELD);
            this.put("connectorSuppliedValues", CONNECTOR_SUPPLIED_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String key;
    private final Boolean isRequired;
    private final String label;
    private final String description;
    private final Boolean isSensitiveField;
    private final List<String> connectorSuppliedValues;

    private AuthParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.isRequired = builder.isRequired;
        this.label = builder.label;
        this.description = builder.description;
        this.isSensitiveField = builder.isSensitiveField;
        this.connectorSuppliedValues = builder.connectorSuppliedValues;
    }

    public final String key() {
        return this.key;
    }

    public final Boolean isRequired() {
        return this.isRequired;
    }

    public final String label() {
        return this.label;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isSensitiveField() {
        return this.isSensitiveField;
    }

    public final boolean hasConnectorSuppliedValues() {
        return this.connectorSuppliedValues != null && !(this.connectorSuppliedValues instanceof SdkAutoConstructList);
    }

    public final List<String> connectorSuppliedValues() {
        return this.connectorSuppliedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSensitiveField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorSuppliedValues() ? this.connectorSuppliedValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthParameter)) {
            return false;
        }
        AuthParameter other = (AuthParameter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.isRequired(), other.isRequired()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isSensitiveField(), other.isSensitiveField()) && this.hasConnectorSuppliedValues() == other.hasConnectorSuppliedValues() && Objects.equals(this.connectorSuppliedValues(), other.connectorSuppliedValues());
    }

    public final String toString() {
        return ToString.builder((String)"AuthParameter").add("Key", (Object)this.key()).add("IsRequired", (Object)this.isRequired()).add("Label", (Object)this.label()).add("Description", (Object)this.description()).add("IsSensitiveField", (Object)this.isSensitiveField()).add("ConnectorSuppliedValues", this.hasConnectorSuppliedValues() ? this.connectorSuppliedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "isRequired": {
                return Optional.ofNullable(clazz.cast(this.isRequired()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isSensitiveField": {
                return Optional.ofNullable(clazz.cast(this.isSensitiveField()));
            }
            case "connectorSuppliedValues": {
                return Optional.ofNullable(clazz.cast(this.connectorSuppliedValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthParameter, T> g) {
        return obj -> g.apply((AuthParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private Boolean isRequired;
        private String label;
        private String description;
        private Boolean isSensitiveField;
        private List<String> connectorSuppliedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthParameter model) {
            this.key(model.key);
            this.isRequired(model.isRequired);
            this.label(model.label);
            this.description(model.description);
            this.isSensitiveField(model.isSensitiveField);
            this.connectorSuppliedValues(model.connectorSuppliedValues);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Boolean getIsRequired() {
            return this.isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsSensitiveField() {
            return this.isSensitiveField;
        }

        public final void setIsSensitiveField(Boolean isSensitiveField) {
            this.isSensitiveField = isSensitiveField;
        }

        @Override
        public final Builder isSensitiveField(Boolean isSensitiveField) {
            this.isSensitiveField = isSensitiveField;
            return this;
        }

        public final Collection<String> getConnectorSuppliedValues() {
            if (this.connectorSuppliedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorSuppliedValues;
        }

        public final void setConnectorSuppliedValues(Collection<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = ConnectorSuppliedValueListCopier.copy(connectorSuppliedValues);
        }

        @Override
        public final Builder connectorSuppliedValues(Collection<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = ConnectorSuppliedValueListCopier.copy(connectorSuppliedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorSuppliedValues(String ... connectorSuppliedValues) {
            this.connectorSuppliedValues(Arrays.asList(connectorSuppliedValues));
            return this;
        }

        public AuthParameter build() {
            return new AuthParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthParameter> {
        public Builder key(String var1);

        public Builder isRequired(Boolean var1);

        public Builder label(String var1);

        public Builder description(String var1);

        public Builder isSensitiveField(Boolean var1);

        public Builder connectorSuppliedValues(Collection<String> var1);

        public Builder connectorSuppliedValues(String ... var1);
    }
}

