/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeConnectorProfileProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeConnectorProfileProperties> {
    private static final SdkField<String> WAREHOUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warehouse").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::warehouse)).setter(SnowflakeConnectorProfileProperties.setter(Builder::warehouse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warehouse").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::stage)).setter(SnowflakeConnectorProfileProperties.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::bucketName)).setter(SnowflakeConnectorProfileProperties.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketPrefix").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::bucketPrefix)).setter(SnowflakeConnectorProfileProperties.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()}).build();
    private static final SdkField<String> PRIVATE_LINK_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateLinkServiceName").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::privateLinkServiceName)).setter(SnowflakeConnectorProfileProperties.setter(Builder::privateLinkServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateLinkServiceName").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountName").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::accountName)).setter(SnowflakeConnectorProfileProperties.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(SnowflakeConnectorProfileProperties.getter(SnowflakeConnectorProfileProperties::region)).setter(SnowflakeConnectorProfileProperties.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAREHOUSE_FIELD, STAGE_FIELD, BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, PRIVATE_LINK_SERVICE_NAME_FIELD, ACCOUNT_NAME_FIELD, REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("warehouse", WAREHOUSE_FIELD);
            this.put("stage", STAGE_FIELD);
            this.put("bucketName", BUCKET_NAME_FIELD);
            this.put("bucketPrefix", BUCKET_PREFIX_FIELD);
            this.put("privateLinkServiceName", PRIVATE_LINK_SERVICE_NAME_FIELD);
            this.put("accountName", ACCOUNT_NAME_FIELD);
            this.put("region", REGION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String warehouse;
    private final String stage;
    private final String bucketName;
    private final String bucketPrefix;
    private final String privateLinkServiceName;
    private final String accountName;
    private final String region;

    private SnowflakeConnectorProfileProperties(BuilderImpl builder) {
        this.warehouse = builder.warehouse;
        this.stage = builder.stage;
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.privateLinkServiceName = builder.privateLinkServiceName;
        this.accountName = builder.accountName;
        this.region = builder.region;
    }

    public final String warehouse() {
        return this.warehouse;
    }

    public final String stage() {
        return this.stage;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketPrefix() {
        return this.bucketPrefix;
    }

    public final String privateLinkServiceName() {
        return this.privateLinkServiceName;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.warehouse());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateLinkServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeConnectorProfileProperties)) {
            return false;
        }
        SnowflakeConnectorProfileProperties other = (SnowflakeConnectorProfileProperties)obj;
        return Objects.equals(this.warehouse(), other.warehouse()) && Objects.equals(this.stage(), other.stage()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix()) && Objects.equals(this.privateLinkServiceName(), other.privateLinkServiceName()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeConnectorProfileProperties").add("Warehouse", (Object)this.warehouse()).add("Stage", (Object)this.stage()).add("BucketName", (Object)this.bucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).add("PrivateLinkServiceName", (Object)this.privateLinkServiceName()).add("AccountName", (Object)this.accountName()).add("Region", (Object)this.region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "warehouse": {
                return Optional.ofNullable(clazz.cast(this.warehouse()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "bucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
            case "privateLinkServiceName": {
                return Optional.ofNullable(clazz.cast(this.privateLinkServiceName()));
            }
            case "accountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeConnectorProfileProperties, T> g) {
        return obj -> g.apply((SnowflakeConnectorProfileProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String warehouse;
        private String stage;
        private String bucketName;
        private String bucketPrefix;
        private String privateLinkServiceName;
        private String accountName;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeConnectorProfileProperties model) {
            this.warehouse(model.warehouse);
            this.stage(model.stage);
            this.bucketName(model.bucketName);
            this.bucketPrefix(model.bucketPrefix);
            this.privateLinkServiceName(model.privateLinkServiceName);
            this.accountName(model.accountName);
            this.region(model.region);
        }

        public final String getWarehouse() {
            return this.warehouse;
        }

        public final void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        @Override
        public final Builder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getPrivateLinkServiceName() {
            return this.privateLinkServiceName;
        }

        public final void setPrivateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
        }

        @Override
        public final Builder privateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
            return this;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public SnowflakeConnectorProfileProperties build() {
            return new SnowflakeConnectorProfileProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeConnectorProfileProperties> {
        public Builder warehouse(String var1);

        public Builder stage(String var1);

        public Builder bucketName(String var1);

        public Builder bucketPrefix(String var1);

        public Builder privateLinkServiceName(String var1);

        public Builder accountName(String var1);

        public Builder region(String var1);
    }
}

