/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.ConnectorOperator;
import software.amazon.awssdk.services.appflow.model.OperatorPropertiesKeys;
import software.amazon.awssdk.services.appflow.model.SourceFieldsCopier;
import software.amazon.awssdk.services.appflow.model.TaskPropertiesMapCopier;
import software.amazon.awssdk.services.appflow.model.TaskType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Task
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Task> {
    private static final SdkField<List<String>> SOURCE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceFields").getter(Task.getter(Task::sourceFields)).setter(Task.setter(Builder::sourceFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectorOperator> CONNECTOR_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorOperator").getter(Task.getter(Task::connectorOperator)).setter(Task.setter(Builder::connectorOperator)).constructor(ConnectorOperator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperator").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationField").getter(Task.getter(Task::destinationField)).setter(Task.setter(Builder::destinationField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationField").build()}).build();
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskType").getter(Task.getter(Task::taskTypeAsString)).setter(Task.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskType").build()}).build();
    private static final SdkField<Map<String, String>> TASK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskProperties").getter(Task.getter(Task::taskPropertiesAsStrings)).setter(Task.setter(Builder::taskPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELDS_FIELD, CONNECTOR_OPERATOR_FIELD, DESTINATION_FIELD_FIELD, TASK_TYPE_FIELD, TASK_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sourceFields", SOURCE_FIELDS_FIELD);
            this.put("connectorOperator", CONNECTOR_OPERATOR_FIELD);
            this.put("destinationField", DESTINATION_FIELD_FIELD);
            this.put("taskType", TASK_TYPE_FIELD);
            this.put("taskProperties", TASK_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> sourceFields;
    private final ConnectorOperator connectorOperator;
    private final String destinationField;
    private final String taskType;
    private final Map<String, String> taskProperties;

    private Task(BuilderImpl builder) {
        this.sourceFields = builder.sourceFields;
        this.connectorOperator = builder.connectorOperator;
        this.destinationField = builder.destinationField;
        this.taskType = builder.taskType;
        this.taskProperties = builder.taskProperties;
    }

    public final boolean hasSourceFields() {
        return this.sourceFields != null && !(this.sourceFields instanceof SdkAutoConstructList);
    }

    public final List<String> sourceFields() {
        return this.sourceFields;
    }

    public final ConnectorOperator connectorOperator() {
        return this.connectorOperator;
    }

    public final String destinationField() {
        return this.destinationField;
    }

    public final TaskType taskType() {
        return TaskType.fromValue(this.taskType);
    }

    public final String taskTypeAsString() {
        return this.taskType;
    }

    public final Map<OperatorPropertiesKeys, String> taskProperties() {
        return TaskPropertiesMapCopier.copyStringToEnum(this.taskProperties);
    }

    public final boolean hasTaskProperties() {
        return this.taskProperties != null && !(this.taskProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> taskPropertiesAsStrings() {
        return this.taskProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceFields() ? this.sourceFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperator());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationField());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskProperties() ? this.taskPropertiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        return this.hasSourceFields() == other.hasSourceFields() && Objects.equals(this.sourceFields(), other.sourceFields()) && Objects.equals(this.connectorOperator(), other.connectorOperator()) && Objects.equals(this.destinationField(), other.destinationField()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && this.hasTaskProperties() == other.hasTaskProperties() && Objects.equals(this.taskPropertiesAsStrings(), other.taskPropertiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Task").add("SourceFields", this.hasSourceFields() ? this.sourceFields() : null).add("ConnectorOperator", (Object)this.connectorOperator()).add("DestinationField", (Object)this.destinationField()).add("TaskType", (Object)this.taskTypeAsString()).add("TaskProperties", this.hasTaskProperties() ? this.taskPropertiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceFields": {
                return Optional.ofNullable(clazz.cast(this.sourceFields()));
            }
            case "connectorOperator": {
                return Optional.ofNullable(clazz.cast(this.connectorOperator()));
            }
            case "destinationField": {
                return Optional.ofNullable(clazz.cast(this.destinationField()));
            }
            case "taskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "taskProperties": {
                return Optional.ofNullable(clazz.cast(this.taskPropertiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Task, T> g) {
        return obj -> g.apply((Task)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sourceFields = DefaultSdkAutoConstructList.getInstance();
        private ConnectorOperator connectorOperator;
        private String destinationField;
        private String taskType;
        private Map<String, String> taskProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            this.sourceFields(model.sourceFields);
            this.connectorOperator(model.connectorOperator);
            this.destinationField(model.destinationField);
            this.taskType(model.taskType);
            this.taskPropertiesWithStrings(model.taskProperties);
        }

        public final Collection<String> getSourceFields() {
            if (this.sourceFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceFields;
        }

        public final void setSourceFields(Collection<String> sourceFields) {
            this.sourceFields = SourceFieldsCopier.copy(sourceFields);
        }

        @Override
        public final Builder sourceFields(Collection<String> sourceFields) {
            this.sourceFields = SourceFieldsCopier.copy(sourceFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceFields(String ... sourceFields) {
            this.sourceFields(Arrays.asList(sourceFields));
            return this;
        }

        public final ConnectorOperator.Builder getConnectorOperator() {
            return this.connectorOperator != null ? this.connectorOperator.toBuilder() : null;
        }

        public final void setConnectorOperator(ConnectorOperator.BuilderImpl connectorOperator) {
            this.connectorOperator = connectorOperator != null ? connectorOperator.build() : null;
        }

        @Override
        public final Builder connectorOperator(ConnectorOperator connectorOperator) {
            this.connectorOperator = connectorOperator;
            return this;
        }

        public final String getDestinationField() {
            return this.destinationField;
        }

        public final void setDestinationField(String destinationField) {
            this.destinationField = destinationField;
        }

        @Override
        public final Builder destinationField(String destinationField) {
            this.destinationField = destinationField;
            return this;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(TaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final Map<String, String> getTaskProperties() {
            if (this.taskProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.taskProperties;
        }

        public final void setTaskProperties(Map<String, String> taskProperties) {
            this.taskProperties = TaskPropertiesMapCopier.copy(taskProperties);
        }

        @Override
        public final Builder taskPropertiesWithStrings(Map<String, String> taskProperties) {
            this.taskProperties = TaskPropertiesMapCopier.copy(taskProperties);
            return this;
        }

        @Override
        public final Builder taskProperties(Map<OperatorPropertiesKeys, String> taskProperties) {
            this.taskProperties = TaskPropertiesMapCopier.copyEnumToString(taskProperties);
            return this;
        }

        public Task build() {
            return new Task(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Task> {
        public Builder sourceFields(Collection<String> var1);

        public Builder sourceFields(String ... var1);

        public Builder connectorOperator(ConnectorOperator var1);

        default public Builder connectorOperator(Consumer<ConnectorOperator.Builder> connectorOperator) {
            return this.connectorOperator((ConnectorOperator)((ConnectorOperator.Builder)ConnectorOperator.builder().applyMutation(connectorOperator)).build());
        }

        public Builder destinationField(String var1);

        public Builder taskType(String var1);

        public Builder taskType(TaskType var1);

        public Builder taskPropertiesWithStrings(Map<String, String> var1);

        public Builder taskProperties(Map<OperatorPropertiesKeys, String> var1);
    }
}

