/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.OAuthScopeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuthProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuthProperties> {
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenUrl").getter(OAuthProperties.getter(OAuthProperties::tokenUrl)).setter(OAuthProperties.setter(Builder::tokenUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()}).build();
    private static final SdkField<String> AUTH_CODE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authCodeUrl").getter(OAuthProperties.getter(OAuthProperties::authCodeUrl)).setter(OAuthProperties.setter(Builder::authCodeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCodeUrl").build()}).build();
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oAuthScopes").getter(OAuthProperties.getter(OAuthProperties::oAuthScopes)).setter(OAuthProperties.setter(Builder::oAuthScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_URL_FIELD, AUTH_CODE_URL_FIELD, O_AUTH_SCOPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tokenUrl", TOKEN_URL_FIELD);
            this.put("authCodeUrl", AUTH_CODE_URL_FIELD);
            this.put("oAuthScopes", O_AUTH_SCOPES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String tokenUrl;
    private final String authCodeUrl;
    private final List<String> oAuthScopes;

    private OAuthProperties(BuilderImpl builder) {
        this.tokenUrl = builder.tokenUrl;
        this.authCodeUrl = builder.authCodeUrl;
        this.oAuthScopes = builder.oAuthScopes;
    }

    public final String tokenUrl() {
        return this.tokenUrl;
    }

    public final String authCodeUrl() {
        return this.authCodeUrl;
    }

    public final boolean hasOAuthScopes() {
        return this.oAuthScopes != null && !(this.oAuthScopes instanceof SdkAutoConstructList);
    }

    public final List<String> oAuthScopes() {
        return this.oAuthScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOAuthScopes() ? this.oAuthScopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthProperties)) {
            return false;
        }
        OAuthProperties other = (OAuthProperties)obj;
        return Objects.equals(this.tokenUrl(), other.tokenUrl()) && Objects.equals(this.authCodeUrl(), other.authCodeUrl()) && this.hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(this.oAuthScopes(), other.oAuthScopes());
    }

    public final String toString() {
        return ToString.builder((String)"OAuthProperties").add("TokenUrl", (Object)this.tokenUrl()).add("AuthCodeUrl", (Object)this.authCodeUrl()).add("OAuthScopes", this.hasOAuthScopes() ? this.oAuthScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenUrl()));
            }
            case "authCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.authCodeUrl()));
            }
            case "oAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.oAuthScopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OAuthProperties, T> g) {
        return obj -> g.apply((OAuthProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tokenUrl;
        private String authCodeUrl;
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthProperties model) {
            this.tokenUrl(model.tokenUrl);
            this.authCodeUrl(model.authCodeUrl);
            this.oAuthScopes(model.oAuthScopes);
        }

        public final String getTokenUrl() {
            return this.tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final String getAuthCodeUrl() {
            return this.authCodeUrl;
        }

        public final void setAuthCodeUrl(String authCodeUrl) {
            this.authCodeUrl = authCodeUrl;
        }

        @Override
        public final Builder authCodeUrl(String authCodeUrl) {
            this.authCodeUrl = authCodeUrl;
            return this;
        }

        public final Collection<String> getOAuthScopes() {
            if (this.oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oAuthScopes;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
        }

        @Override
        public final Builder oAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(String ... oAuthScopes) {
            this.oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public OAuthProperties build() {
            return new OAuthProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuthProperties> {
        public Builder tokenUrl(String var1);

        public Builder authCodeUrl(String var1);

        public Builder oAuthScopes(Collection<String> var1);

        public Builder oAuthScopes(String ... var1);
    }
}

