/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.BasicAuthCredentials;
import software.amazon.awssdk.services.appflow.model.OAuthCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAPODataConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAPODataConnectorProfileCredentials> {
    private static final SdkField<BasicAuthCredentials> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("basicAuthCredentials").getter(SAPODataConnectorProfileCredentials.getter(SAPODataConnectorProfileCredentials::basicAuthCredentials)).setter(SAPODataConnectorProfileCredentials.setter(Builder::basicAuthCredentials)).constructor(BasicAuthCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<OAuthCredentials> O_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuthCredentials").getter(SAPODataConnectorProfileCredentials.getter(SAPODataConnectorProfileCredentials::oAuthCredentials)).setter(SAPODataConnectorProfileCredentials.setter(Builder::oAuthCredentials)).constructor(OAuthCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthCredentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_CREDENTIALS_FIELD, O_AUTH_CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("basicAuthCredentials", BASIC_AUTH_CREDENTIALS_FIELD);
            this.put("oAuthCredentials", O_AUTH_CREDENTIALS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BasicAuthCredentials basicAuthCredentials;
    private final OAuthCredentials oAuthCredentials;

    private SAPODataConnectorProfileCredentials(BuilderImpl builder) {
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.oAuthCredentials = builder.oAuthCredentials;
    }

    public final BasicAuthCredentials basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public final OAuthCredentials oAuthCredentials() {
        return this.oAuthCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthCredentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataConnectorProfileCredentials)) {
            return false;
        }
        SAPODataConnectorProfileCredentials other = (SAPODataConnectorProfileCredentials)obj;
        return Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && Objects.equals(this.oAuthCredentials(), other.oAuthCredentials());
    }

    public final String toString() {
        return ToString.builder((String)"SAPODataConnectorProfileCredentials").add("BasicAuthCredentials", (Object)this.basicAuthCredentials()).add("OAuthCredentials", (Object)this.oAuthCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "oAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.oAuthCredentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SAPODataConnectorProfileCredentials, T> g) {
        return obj -> g.apply((SAPODataConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BasicAuthCredentials basicAuthCredentials;
        private OAuthCredentials oAuthCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataConnectorProfileCredentials model) {
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.oAuthCredentials(model.oAuthCredentials);
        }

        public final BasicAuthCredentials.Builder getBasicAuthCredentials() {
            return this.basicAuthCredentials != null ? this.basicAuthCredentials.toBuilder() : null;
        }

        public final void setBasicAuthCredentials(BasicAuthCredentials.BuilderImpl basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials != null ? basicAuthCredentials.build() : null;
        }

        @Override
        public final Builder basicAuthCredentials(BasicAuthCredentials basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final OAuthCredentials.Builder getOAuthCredentials() {
            return this.oAuthCredentials != null ? this.oAuthCredentials.toBuilder() : null;
        }

        public final void setOAuthCredentials(OAuthCredentials.BuilderImpl oAuthCredentials) {
            this.oAuthCredentials = oAuthCredentials != null ? oAuthCredentials.build() : null;
        }

        @Override
        public final Builder oAuthCredentials(OAuthCredentials oAuthCredentials) {
            this.oAuthCredentials = oAuthCredentials;
            return this;
        }

        public SAPODataConnectorProfileCredentials build() {
            return new SAPODataConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAPODataConnectorProfileCredentials> {
        public Builder basicAuthCredentials(BasicAuthCredentials var1);

        default public Builder basicAuthCredentials(Consumer<BasicAuthCredentials.Builder> basicAuthCredentials) {
            return this.basicAuthCredentials((BasicAuthCredentials)((BasicAuthCredentials.Builder)BasicAuthCredentials.builder().applyMutation(basicAuthCredentials)).build());
        }

        public Builder oAuthCredentials(OAuthCredentials var1);

        default public Builder oAuthCredentials(Consumer<OAuthCredentials.Builder> oAuthCredentials) {
            return this.oAuthCredentials((OAuthCredentials)((OAuthCredentials.Builder)OAuthCredentials.builder().applyMutation(oAuthCredentials)).build());
        }
    }
}

