/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ApiKeyCredentials;
import software.amazon.awssdk.services.appflow.model.AuthenticationType;
import software.amazon.awssdk.services.appflow.model.BasicAuthCredentials;
import software.amazon.awssdk.services.appflow.model.CustomAuthCredentials;
import software.amazon.awssdk.services.appflow.model.OAuth2Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomConnectorProfileCredentials> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(CustomConnectorProfileCredentials.getter(CustomConnectorProfileCredentials::authenticationTypeAsString)).setter(CustomConnectorProfileCredentials.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<BasicAuthCredentials> BASIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("basic").getter(CustomConnectorProfileCredentials.getter(CustomConnectorProfileCredentials::basic)).setter(CustomConnectorProfileCredentials.setter(Builder::basic)).constructor(BasicAuthCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basic").build()}).build();
    private static final SdkField<OAuth2Credentials> OAUTH2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oauth2").getter(CustomConnectorProfileCredentials.getter(CustomConnectorProfileCredentials::oauth2)).setter(CustomConnectorProfileCredentials.setter(Builder::oauth2)).constructor(OAuth2Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2").build()}).build();
    private static final SdkField<ApiKeyCredentials> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiKey").getter(CustomConnectorProfileCredentials.getter(CustomConnectorProfileCredentials::apiKey)).setter(CustomConnectorProfileCredentials.setter(Builder::apiKey)).constructor(ApiKeyCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()}).build();
    private static final SdkField<CustomAuthCredentials> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("custom").getter(CustomConnectorProfileCredentials.getter(CustomConnectorProfileCredentials::custom)).setter(CustomConnectorProfileCredentials.setter(Builder::custom)).constructor(CustomAuthCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, BASIC_FIELD, OAUTH2_FIELD, API_KEY_FIELD, CUSTOM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
            this.put("basic", BASIC_FIELD);
            this.put("oauth2", OAUTH2_FIELD);
            this.put("apiKey", API_KEY_FIELD);
            this.put("custom", CUSTOM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final BasicAuthCredentials basic;
    private final OAuth2Credentials oauth2;
    private final ApiKeyCredentials apiKey;
    private final CustomAuthCredentials custom;

    private CustomConnectorProfileCredentials(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.basic = builder.basic;
        this.oauth2 = builder.oauth2;
        this.apiKey = builder.apiKey;
        this.custom = builder.custom;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final BasicAuthCredentials basic() {
        return this.basic;
    }

    public final OAuth2Credentials oauth2() {
        return this.oauth2;
    }

    public final ApiKeyCredentials apiKey() {
        return this.apiKey;
    }

    public final CustomAuthCredentials custom() {
        return this.custom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.basic());
        hashCode = 31 * hashCode + Objects.hashCode(this.oauth2());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.custom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorProfileCredentials)) {
            return false;
        }
        CustomConnectorProfileCredentials other = (CustomConnectorProfileCredentials)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.basic(), other.basic()) && Objects.equals(this.oauth2(), other.oauth2()) && Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.custom(), other.custom());
    }

    public final String toString() {
        return ToString.builder((String)"CustomConnectorProfileCredentials").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("Basic", (Object)this.basic()).add("Oauth2", (Object)this.oauth2()).add("ApiKey", (Object)this.apiKey()).add("Custom", (Object)this.custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "basic": {
                return Optional.ofNullable(clazz.cast(this.basic()));
            }
            case "oauth2": {
                return Optional.ofNullable(clazz.cast(this.oauth2()));
            }
            case "apiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "custom": {
                return Optional.ofNullable(clazz.cast(this.custom()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorProfileCredentials, T> g) {
        return obj -> g.apply((CustomConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private BasicAuthCredentials basic;
        private OAuth2Credentials oauth2;
        private ApiKeyCredentials apiKey;
        private CustomAuthCredentials custom;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorProfileCredentials model) {
            this.authenticationType(model.authenticationType);
            this.basic(model.basic);
            this.oauth2(model.oauth2);
            this.apiKey(model.apiKey);
            this.custom(model.custom);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final BasicAuthCredentials.Builder getBasic() {
            return this.basic != null ? this.basic.toBuilder() : null;
        }

        public final void setBasic(BasicAuthCredentials.BuilderImpl basic) {
            this.basic = basic != null ? basic.build() : null;
        }

        @Override
        public final Builder basic(BasicAuthCredentials basic) {
            this.basic = basic;
            return this;
        }

        public final OAuth2Credentials.Builder getOauth2() {
            return this.oauth2 != null ? this.oauth2.toBuilder() : null;
        }

        public final void setOauth2(OAuth2Credentials.BuilderImpl oauth2) {
            this.oauth2 = oauth2 != null ? oauth2.build() : null;
        }

        @Override
        public final Builder oauth2(OAuth2Credentials oauth2) {
            this.oauth2 = oauth2;
            return this;
        }

        public final ApiKeyCredentials.Builder getApiKey() {
            return this.apiKey != null ? this.apiKey.toBuilder() : null;
        }

        public final void setApiKey(ApiKeyCredentials.BuilderImpl apiKey) {
            this.apiKey = apiKey != null ? apiKey.build() : null;
        }

        @Override
        public final Builder apiKey(ApiKeyCredentials apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final CustomAuthCredentials.Builder getCustom() {
            return this.custom != null ? this.custom.toBuilder() : null;
        }

        public final void setCustom(CustomAuthCredentials.BuilderImpl custom) {
            this.custom = custom != null ? custom.build() : null;
        }

        @Override
        public final Builder custom(CustomAuthCredentials custom) {
            this.custom = custom;
            return this;
        }

        public CustomConnectorProfileCredentials build() {
            return new CustomConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomConnectorProfileCredentials> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder basic(BasicAuthCredentials var1);

        default public Builder basic(Consumer<BasicAuthCredentials.Builder> basic) {
            return this.basic((BasicAuthCredentials)((BasicAuthCredentials.Builder)BasicAuthCredentials.builder().applyMutation(basic)).build());
        }

        public Builder oauth2(OAuth2Credentials var1);

        default public Builder oauth2(Consumer<OAuth2Credentials.Builder> oauth2) {
            return this.oauth2((OAuth2Credentials)((OAuth2Credentials.Builder)OAuth2Credentials.builder().applyMutation(oauth2)).build());
        }

        public Builder apiKey(ApiKeyCredentials var1);

        default public Builder apiKey(Consumer<ApiKeyCredentials.Builder> apiKey) {
            return this.apiKey((ApiKeyCredentials)((ApiKeyCredentials.Builder)ApiKeyCredentials.builder().applyMutation(apiKey)).build());
        }

        public Builder custom(CustomAuthCredentials var1);

        default public Builder custom(Consumer<CustomAuthCredentials.Builder> custom) {
            return this.custom((CustomAuthCredentials)((CustomAuthCredentials.Builder)CustomAuthCredentials.builder().applyMutation(custom)).build());
        }
    }
}

