/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.OAuth2Properties;
import software.amazon.awssdk.services.appflow.model.ProfilePropertiesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomConnectorProfileProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomConnectorProfileProperties> {
    private static final SdkField<Map<String, String>> PROFILE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("profileProperties").getter(CustomConnectorProfileProperties.getter(CustomConnectorProfileProperties::profileProperties)).setter(CustomConnectorProfileProperties.setter(Builder::profileProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<OAuth2Properties> O_AUTH2_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2Properties").getter(CustomConnectorProfileProperties.getter(CustomConnectorProfileProperties::oAuth2Properties)).setter(CustomConnectorProfileProperties.setter(Builder::oAuth2Properties)).constructor(OAuth2Properties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_PROPERTIES_FIELD, O_AUTH2_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("profileProperties", PROFILE_PROPERTIES_FIELD);
            this.put("oAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, String> profileProperties;
    private final OAuth2Properties oAuth2Properties;

    private CustomConnectorProfileProperties(BuilderImpl builder) {
        this.profileProperties = builder.profileProperties;
        this.oAuth2Properties = builder.oAuth2Properties;
    }

    public final boolean hasProfileProperties() {
        return this.profileProperties != null && !(this.profileProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> profileProperties() {
        return this.profileProperties;
    }

    public final OAuth2Properties oAuth2Properties() {
        return this.oAuth2Properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileProperties() ? this.profileProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorProfileProperties)) {
            return false;
        }
        CustomConnectorProfileProperties other = (CustomConnectorProfileProperties)obj;
        return this.hasProfileProperties() == other.hasProfileProperties() && Objects.equals(this.profileProperties(), other.profileProperties()) && Objects.equals(this.oAuth2Properties(), other.oAuth2Properties());
    }

    public final String toString() {
        return ToString.builder((String)"CustomConnectorProfileProperties").add("ProfileProperties", this.hasProfileProperties() ? this.profileProperties() : null).add("OAuth2Properties", (Object)this.oAuth2Properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileProperties": {
                return Optional.ofNullable(clazz.cast(this.profileProperties()));
            }
            case "oAuth2Properties": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorProfileProperties, T> g) {
        return obj -> g.apply((CustomConnectorProfileProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> profileProperties = DefaultSdkAutoConstructMap.getInstance();
        private OAuth2Properties oAuth2Properties;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorProfileProperties model) {
            this.profileProperties(model.profileProperties);
            this.oAuth2Properties(model.oAuth2Properties);
        }

        public final Map<String, String> getProfileProperties() {
            if (this.profileProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.profileProperties;
        }

        public final void setProfileProperties(Map<String, String> profileProperties) {
            this.profileProperties = ProfilePropertiesMapCopier.copy(profileProperties);
        }

        @Override
        public final Builder profileProperties(Map<String, String> profileProperties) {
            this.profileProperties = ProfilePropertiesMapCopier.copy(profileProperties);
            return this;
        }

        public final OAuth2Properties.Builder getOAuth2Properties() {
            return this.oAuth2Properties != null ? this.oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2Properties.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2Properties oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        public CustomConnectorProfileProperties build() {
            return new CustomConnectorProfileProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomConnectorProfileProperties> {
        public Builder profileProperties(Map<String, String> var1);

        public Builder oAuth2Properties(OAuth2Properties var1);

        default public Builder oAuth2Properties(Consumer<OAuth2Properties.Builder> oAuth2Properties) {
            return this.oAuth2Properties((OAuth2Properties)((OAuth2Properties.Builder)OAuth2Properties.builder().applyMutation(oAuth2Properties)).build());
        }
    }
}

