/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorProvisioningType {
    LAMBDA("LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorProvisioningType> VALUE_MAP;
    private final String value;

    private ConnectorProvisioningType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorProvisioningType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorProvisioningType> knownValues() {
        EnumSet<ConnectorProvisioningType> knownValues = EnumSet.allOf(ConnectorProvisioningType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorProvisioningType.class, ConnectorProvisioningType::toString);
    }
}

