/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OAuth2CustomPropType {
    TOKEN_URL("TOKEN_URL"),
    AUTH_URL("AUTH_URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OAuth2CustomPropType> VALUE_MAP;
    private final String value;

    private OAuth2CustomPropType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OAuth2CustomPropType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OAuth2CustomPropType> knownValues() {
        EnumSet<OAuth2CustomPropType> knownValues = EnumSet.allOf(OAuth2CustomPropType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OAuth2CustomPropType.class, OAuth2CustomPropType::toString);
    }
}

