/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFlowRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, DeleteFlowRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(DeleteFlowRequest.getter(DeleteFlowRequest::flowName)).setter(DeleteFlowRequest.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceDelete").getter(DeleteFlowRequest.getter(DeleteFlowRequest::forceDelete)).setter(DeleteFlowRequest.setter(Builder::forceDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDelete").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD, FORCE_DELETE_FIELD));
    private final String flowName;
    private final Boolean forceDelete;

    private DeleteFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.forceDelete = builder.forceDelete;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final Boolean forceDelete() {
        return this.forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDelete());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowRequest)) {
            return false;
        }
        DeleteFlowRequest other = (DeleteFlowRequest)((Object)obj);
        return Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.forceDelete(), other.forceDelete());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFlowRequest").add("FlowName", (Object)this.flowName()).add("ForceDelete", (Object)this.forceDelete()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "forceDelete": {
                return Optional.ofNullable(clazz.cast(this.forceDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFlowRequest, T> g) {
        return obj -> g.apply((DeleteFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String flowName;
        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowRequest model) {
            super(model);
            this.flowName(model.flowName);
            this.forceDelete(model.forceDelete);
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final Boolean getForceDelete() {
            return this.forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowRequest build() {
            return new DeleteFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFlowRequest> {
        public Builder flowName(String var1);

        public Builder forceDelete(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

