/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appflow.AppflowAsyncClient;
import software.amazon.awssdk.services.appflow.internal.UserAgentUtils;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse;

public class DescribeConnectorsPublisher
implements SdkPublisher<DescribeConnectorsResponse> {
    private final AppflowAsyncClient client;
    private final DescribeConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConnectorsPublisher(AppflowAsyncClient client, DescribeConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConnectorsPublisher(AppflowAsyncClient client, DescribeConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeConnectorsResponseFetcher
    implements AsyncPageFetcher<DescribeConnectorsResponse> {
        private DescribeConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConnectorsResponse> nextPage(DescribeConnectorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConnectorsPublisher.this.client.describeConnectors(DescribeConnectorsPublisher.this.firstRequest);
            }
            return DescribeConnectorsPublisher.this.client.describeConnectors((DescribeConnectorsRequest)((Object)DescribeConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

