/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties required when using Snowflake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeConnectorProfileProperties.Builder, SnowflakeConnectorProfileProperties> {
    private static final SdkField<String> WAREHOUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warehouse").getter(getter(SnowflakeConnectorProfileProperties::warehouse))
            .setter(setter(Builder::warehouse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warehouse").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(SnowflakeConnectorProfileProperties::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(SnowflakeConnectorProfileProperties::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(SnowflakeConnectorProfileProperties::bucketPrefix))
            .setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<String> PRIVATE_LINK_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateLinkServiceName").getter(getter(SnowflakeConnectorProfileProperties::privateLinkServiceName))
            .setter(setter(Builder::privateLinkServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateLinkServiceName").build())
            .build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountName").getter(getter(SnowflakeConnectorProfileProperties::accountName))
            .setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(SnowflakeConnectorProfileProperties::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAREHOUSE_FIELD, STAGE_FIELD,
            BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, PRIVATE_LINK_SERVICE_NAME_FIELD, ACCOUNT_NAME_FIELD, REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String warehouse;

    private final String stage;

    private final String bucketName;

    private final String bucketPrefix;

    private final String privateLinkServiceName;

    private final String accountName;

    private final String region;

    private SnowflakeConnectorProfileProperties(BuilderImpl builder) {
        this.warehouse = builder.warehouse;
        this.stage = builder.stage;
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.privateLinkServiceName = builder.privateLinkServiceName;
        this.accountName = builder.accountName;
        this.region = builder.region;
    }

    /**
     * <p>
     * The name of the Snowflake warehouse.
     * </p>
     * 
     * @return The name of the Snowflake warehouse.
     */
    public final String warehouse() {
        return warehouse;
    }

    /**
     * <p>
     * The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account.
     * This is written in the following format: &lt; Database&gt;&lt; Schema&gt;&lt;Stage Name&gt;.
     * </p>
     * 
     * @return The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake
     *         account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;&lt;Stage Name&gt;.
     */
    public final String stage() {
        return stage;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket associated with Snowflake.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket associated with Snowflake.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
     * </p>
     * 
     * @return The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The Snowflake Private Link service name to be used for private data transfers.
     * </p>
     * 
     * @return The Snowflake Private Link service name to be used for private data transfers.
     */
    public final String privateLinkServiceName() {
        return privateLinkServiceName;
    }

    /**
     * <p>
     * The name of the account.
     * </p>
     * 
     * @return The name of the account.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the Snowflake account.
     * </p>
     * 
     * @return The Amazon Web Services Region of the Snowflake account.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(warehouse());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(privateLinkServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeConnectorProfileProperties)) {
            return false;
        }
        SnowflakeConnectorProfileProperties other = (SnowflakeConnectorProfileProperties) obj;
        return Objects.equals(warehouse(), other.warehouse()) && Objects.equals(stage(), other.stage())
                && Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(privateLinkServiceName(), other.privateLinkServiceName())
                && Objects.equals(accountName(), other.accountName()) && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeConnectorProfileProperties").add("Warehouse", warehouse()).add("Stage", stage())
                .add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix())
                .add("PrivateLinkServiceName", privateLinkServiceName()).add("AccountName", accountName())
                .add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "warehouse":
            return Optional.ofNullable(clazz.cast(warehouse()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "privateLinkServiceName":
            return Optional.ofNullable(clazz.cast(privateLinkServiceName()));
        case "accountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeConnectorProfileProperties, T> g) {
        return obj -> g.apply((SnowflakeConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeConnectorProfileProperties> {
        /**
         * <p>
         * The name of the Snowflake warehouse.
         * </p>
         * 
         * @param warehouse
         *        The name of the Snowflake warehouse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warehouse(String warehouse);

        /**
         * <p>
         * The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake
         * account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;&lt;Stage Name&gt;.
         * </p>
         * 
         * @param stage
         *        The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake
         *        account. This is written in the following format: &lt; Database&gt;&lt; Schema&gt;&lt;Stage Name&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);

        /**
         * <p>
         * The name of the Amazon S3 bucket associated with Snowflake.
         * </p>
         * 
         * @param bucketName
         *        The name of the Amazon S3 bucket associated with Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
         * </p>
         * 
         * @param bucketPrefix
         *        The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The Snowflake Private Link service name to be used for private data transfers.
         * </p>
         * 
         * @param privateLinkServiceName
         *        The Snowflake Private Link service name to be used for private data transfers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateLinkServiceName(String privateLinkServiceName);

        /**
         * <p>
         * The name of the account.
         * </p>
         * 
         * @param accountName
         *        The name of the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The Amazon Web Services Region of the Snowflake account.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region of the Snowflake account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String warehouse;

        private String stage;

        private String bucketName;

        private String bucketPrefix;

        private String privateLinkServiceName;

        private String accountName;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeConnectorProfileProperties model) {
            warehouse(model.warehouse);
            stage(model.stage);
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            privateLinkServiceName(model.privateLinkServiceName);
            accountName(model.accountName);
            region(model.region);
        }

        public final String getWarehouse() {
            return warehouse;
        }

        public final void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        @Override
        public final Builder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getPrivateLinkServiceName() {
            return privateLinkServiceName;
        }

        public final void setPrivateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
        }

        @Override
        public final Builder privateLinkServiceName(String privateLinkServiceName) {
            this.privateLinkServiceName = privateLinkServiceName;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public SnowflakeConnectorProfileProperties build() {
            return new SnowflakeConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
