/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The high-level entity that can be queried in Amazon AppFlow. For example, a Salesforce entity might be an
 * <i>Account</i> or <i>Opportunity</i>, whereas a ServiceNow entity might be an <i>Incident</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorEntity implements SdkPojo, Serializable, ToCopyableBuilder<ConnectorEntity.Builder, ConnectorEntity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConnectorEntity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(ConnectorEntity::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<Boolean> HAS_NESTED_ENTITIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasNestedEntities").getter(getter(ConnectorEntity::hasNestedEntities))
            .setter(setter(Builder::hasNestedEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasNestedEntities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LABEL_FIELD,
            HAS_NESTED_ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String label;

    private final Boolean hasNestedEntities;

    private ConnectorEntity(BuilderImpl builder) {
        this.name = builder.name;
        this.label = builder.label;
        this.hasNestedEntities = builder.hasNestedEntities;
    }

    /**
     * <p>
     * The name of the connector entity.
     * </p>
     * 
     * @return The name of the connector entity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The label applied to the connector entity.
     * </p>
     * 
     * @return The label applied to the connector entity.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If
     * another call is made with <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then
     * it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a
     * recursive fashion.
     * </p>
     * 
     * @return Specifies whether the connector entity is a parent or a category and has more entities nested underneath
     *         it. If another call is made with
     *         <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the
     *         nested entities underneath it. This provides a way to retrieve all supported entities in a recursive
     *         fashion.
     */
    public final Boolean hasNestedEntities() {
        return hasNestedEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(hasNestedEntities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntity)) {
            return false;
        }
        ConnectorEntity other = (ConnectorEntity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(label(), other.label())
                && Objects.equals(hasNestedEntities(), other.hasNestedEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorEntity").add("Name", name()).add("Label", label())
                .add("HasNestedEntities", hasNestedEntities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "hasNestedEntities":
            return Optional.ofNullable(clazz.cast(hasNestedEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorEntity, T> g) {
        return obj -> g.apply((ConnectorEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorEntity> {
        /**
         * <p>
         * The name of the connector entity.
         * </p>
         * 
         * @param name
         *        The name of the connector entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The label applied to the connector entity.
         * </p>
         * 
         * @param label
         *        The label applied to the connector entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Specifies whether the connector entity is a parent or a category and has more entities nested underneath it.
         * If another call is made with
         * <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the nested
         * entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion.
         * </p>
         * 
         * @param hasNestedEntities
         *        Specifies whether the connector entity is a parent or a category and has more entities nested
         *        underneath it. If another call is made with
         *        <code>entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"</code>, then it returns the
         *        nested entities underneath it. This provides a way to retrieve all supported entities in a recursive
         *        fashion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasNestedEntities(Boolean hasNestedEntities);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String label;

        private Boolean hasNestedEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorEntity model) {
            name(model.name);
            label(model.label);
            hasNestedEntities(model.hasNestedEntities);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getHasNestedEntities() {
            return hasNestedEntities;
        }

        public final void setHasNestedEntities(Boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
        }

        @Override
        public final Builder hasNestedEntities(Boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
            return this;
        }

        @Override
        public ConnectorEntity build() {
            return new ConnectorEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
