/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PrefixType {
    FILENAME("FILENAME"),
    PATH("PATH"),
    PATH_AND_FILENAME("PATH_AND_FILENAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PrefixType> VALUE_MAP;
    private final String value;

    private PrefixType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PrefixType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PrefixType> knownValues() {
        EnumSet<PrefixType> knownValues = EnumSet.allOf(PrefixType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PrefixType.class, PrefixType::toString);
    }
}

