/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.SupportedWriteOperationListCopier;
import software.amazon.awssdk.services.appflow.model.WriteOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationFieldProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationFieldProperties> {
    private static final SdkField<Boolean> IS_CREATABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isCreatable").getter(DestinationFieldProperties.getter(DestinationFieldProperties::isCreatable)).setter(DestinationFieldProperties.setter(Builder::isCreatable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCreatable").build()}).build();
    private static final SdkField<Boolean> IS_NULLABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isNullable").getter(DestinationFieldProperties.getter(DestinationFieldProperties::isNullable)).setter(DestinationFieldProperties.setter(Builder::isNullable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNullable").build()}).build();
    private static final SdkField<Boolean> IS_UPSERTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isUpsertable").getter(DestinationFieldProperties.getter(DestinationFieldProperties::isUpsertable)).setter(DestinationFieldProperties.setter(Builder::isUpsertable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isUpsertable").build()}).build();
    private static final SdkField<Boolean> IS_UPDATABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isUpdatable").getter(DestinationFieldProperties.getter(DestinationFieldProperties::isUpdatable)).setter(DestinationFieldProperties.setter(Builder::isUpdatable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isUpdatable").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULTED_ON_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDefaultedOnCreate").getter(DestinationFieldProperties.getter(DestinationFieldProperties::isDefaultedOnCreate)).setter(DestinationFieldProperties.setter(Builder::isDefaultedOnCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultedOnCreate").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_WRITE_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedWriteOperations").getter(DestinationFieldProperties.getter(DestinationFieldProperties::supportedWriteOperationsAsStrings)).setter(DestinationFieldProperties.setter(Builder::supportedWriteOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedWriteOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_CREATABLE_FIELD, IS_NULLABLE_FIELD, IS_UPSERTABLE_FIELD, IS_UPDATABLE_FIELD, IS_DEFAULTED_ON_CREATE_FIELD, SUPPORTED_WRITE_OPERATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isCreatable;
    private final Boolean isNullable;
    private final Boolean isUpsertable;
    private final Boolean isUpdatable;
    private final Boolean isDefaultedOnCreate;
    private final List<String> supportedWriteOperations;

    private DestinationFieldProperties(BuilderImpl builder) {
        this.isCreatable = builder.isCreatable;
        this.isNullable = builder.isNullable;
        this.isUpsertable = builder.isUpsertable;
        this.isUpdatable = builder.isUpdatable;
        this.isDefaultedOnCreate = builder.isDefaultedOnCreate;
        this.supportedWriteOperations = builder.supportedWriteOperations;
    }

    public final Boolean isCreatable() {
        return this.isCreatable;
    }

    public final Boolean isNullable() {
        return this.isNullable;
    }

    public final Boolean isUpsertable() {
        return this.isUpsertable;
    }

    public final Boolean isUpdatable() {
        return this.isUpdatable;
    }

    public final Boolean isDefaultedOnCreate() {
        return this.isDefaultedOnCreate;
    }

    public final List<WriteOperationType> supportedWriteOperations() {
        return SupportedWriteOperationListCopier.copyStringToEnum(this.supportedWriteOperations);
    }

    public final boolean hasSupportedWriteOperations() {
        return this.supportedWriteOperations != null && !(this.supportedWriteOperations instanceof SdkAutoConstructList);
    }

    public final List<String> supportedWriteOperationsAsStrings() {
        return this.supportedWriteOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isCreatable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNullable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUpsertable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUpdatable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultedOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedWriteOperations() ? this.supportedWriteOperationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationFieldProperties)) {
            return false;
        }
        DestinationFieldProperties other = (DestinationFieldProperties)obj;
        return Objects.equals(this.isCreatable(), other.isCreatable()) && Objects.equals(this.isNullable(), other.isNullable()) && Objects.equals(this.isUpsertable(), other.isUpsertable()) && Objects.equals(this.isUpdatable(), other.isUpdatable()) && Objects.equals(this.isDefaultedOnCreate(), other.isDefaultedOnCreate()) && this.hasSupportedWriteOperations() == other.hasSupportedWriteOperations() && Objects.equals(this.supportedWriteOperationsAsStrings(), other.supportedWriteOperationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationFieldProperties").add("IsCreatable", (Object)this.isCreatable()).add("IsNullable", (Object)this.isNullable()).add("IsUpsertable", (Object)this.isUpsertable()).add("IsUpdatable", (Object)this.isUpdatable()).add("IsDefaultedOnCreate", (Object)this.isDefaultedOnCreate()).add("SupportedWriteOperations", this.hasSupportedWriteOperations() ? this.supportedWriteOperationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isCreatable": {
                return Optional.ofNullable(clazz.cast(this.isCreatable()));
            }
            case "isNullable": {
                return Optional.ofNullable(clazz.cast(this.isNullable()));
            }
            case "isUpsertable": {
                return Optional.ofNullable(clazz.cast(this.isUpsertable()));
            }
            case "isUpdatable": {
                return Optional.ofNullable(clazz.cast(this.isUpdatable()));
            }
            case "isDefaultedOnCreate": {
                return Optional.ofNullable(clazz.cast(this.isDefaultedOnCreate()));
            }
            case "supportedWriteOperations": {
                return Optional.ofNullable(clazz.cast(this.supportedWriteOperationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationFieldProperties, T> g) {
        return obj -> g.apply((DestinationFieldProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isCreatable;
        private Boolean isNullable;
        private Boolean isUpsertable;
        private Boolean isUpdatable;
        private Boolean isDefaultedOnCreate;
        private List<String> supportedWriteOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationFieldProperties model) {
            this.isCreatable(model.isCreatable);
            this.isNullable(model.isNullable);
            this.isUpsertable(model.isUpsertable);
            this.isUpdatable(model.isUpdatable);
            this.isDefaultedOnCreate(model.isDefaultedOnCreate);
            this.supportedWriteOperationsWithStrings(model.supportedWriteOperations);
        }

        public final Boolean getIsCreatable() {
            return this.isCreatable;
        }

        public final void setIsCreatable(Boolean isCreatable) {
            this.isCreatable = isCreatable;
        }

        @Override
        public final Builder isCreatable(Boolean isCreatable) {
            this.isCreatable = isCreatable;
            return this;
        }

        public final Boolean getIsNullable() {
            return this.isNullable;
        }

        public final void setIsNullable(Boolean isNullable) {
            this.isNullable = isNullable;
        }

        @Override
        public final Builder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public final Boolean getIsUpsertable() {
            return this.isUpsertable;
        }

        public final void setIsUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
        }

        @Override
        public final Builder isUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
            return this;
        }

        public final Boolean getIsUpdatable() {
            return this.isUpdatable;
        }

        public final void setIsUpdatable(Boolean isUpdatable) {
            this.isUpdatable = isUpdatable;
        }

        @Override
        public final Builder isUpdatable(Boolean isUpdatable) {
            this.isUpdatable = isUpdatable;
            return this;
        }

        public final Boolean getIsDefaultedOnCreate() {
            return this.isDefaultedOnCreate;
        }

        public final void setIsDefaultedOnCreate(Boolean isDefaultedOnCreate) {
            this.isDefaultedOnCreate = isDefaultedOnCreate;
        }

        @Override
        public final Builder isDefaultedOnCreate(Boolean isDefaultedOnCreate) {
            this.isDefaultedOnCreate = isDefaultedOnCreate;
            return this;
        }

        public final Collection<String> getSupportedWriteOperations() {
            if (this.supportedWriteOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedWriteOperations;
        }

        public final void setSupportedWriteOperations(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
        }

        @Override
        public final Builder supportedWriteOperationsWithStrings(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedWriteOperationsWithStrings(String ... supportedWriteOperations) {
            this.supportedWriteOperationsWithStrings(Arrays.asList(supportedWriteOperations));
            return this;
        }

        @Override
        public final Builder supportedWriteOperations(Collection<WriteOperationType> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copyEnumToString(supportedWriteOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedWriteOperations(WriteOperationType ... supportedWriteOperations) {
            this.supportedWriteOperations(Arrays.asList(supportedWriteOperations));
            return this;
        }

        public DestinationFieldProperties build() {
            return new DestinationFieldProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationFieldProperties> {
        public Builder isCreatable(Boolean var1);

        public Builder isNullable(Boolean var1);

        public Builder isUpsertable(Boolean var1);

        public Builder isUpdatable(Boolean var1);

        public Builder isDefaultedOnCreate(Boolean var1);

        public Builder supportedWriteOperationsWithStrings(Collection<String> var1);

        public Builder supportedWriteOperationsWithStrings(String ... var1);

        public Builder supportedWriteOperations(Collection<WriteOperationType> var1);

        public Builder supportedWriteOperations(WriteOperationType ... var1);
    }
}

