/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorsResponse;

public class DescribeConnectorsIterable
implements SdkIterable<DescribeConnectorsResponse> {
    private final AppflowClient client;
    private final DescribeConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConnectorsIterable(AppflowClient client, DescribeConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeConnectorsResponseFetcher();
    }

    public Iterator<DescribeConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeConnectorsResponseFetcher
    implements SyncPageFetcher<DescribeConnectorsResponse> {
        private DescribeConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConnectorsResponse nextPage(DescribeConnectorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConnectorsIterable.this.client.describeConnectors(DescribeConnectorsIterable.this.firstRequest);
            }
            return DescribeConnectorsIterable.this.client.describeConnectors((DescribeConnectorsRequest)((Object)DescribeConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

