/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OAuth2GrantType {
    CLIENT_CREDENTIALS("CLIENT_CREDENTIALS"),
    AUTHORIZATION_CODE("AUTHORIZATION_CODE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OAuth2GrantType> VALUE_MAP;
    private final String value;

    private OAuth2GrantType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OAuth2GrantType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OAuth2GrantType> knownValues() {
        EnumSet<OAuth2GrantType> knownValues = EnumSet.allOf(OAuth2GrantType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OAuth2GrantType.class, OAuth2GrantType::toString);
    }
}

