/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.CredentialsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomAuthCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomAuthCredentials> {
    private static final SdkField<String> CUSTOM_AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customAuthenticationType").getter(CustomAuthCredentials.getter(CustomAuthCredentials::customAuthenticationType)).setter(CustomAuthCredentials.setter(Builder::customAuthenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthenticationType").build()}).build();
    private static final SdkField<Map<String, String>> CREDENTIALS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("credentialsMap").getter(CustomAuthCredentials.getter(CustomAuthCredentials::credentialsMap)).setter(CustomAuthCredentials.setter(Builder::credentialsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_AUTHENTICATION_TYPE_FIELD, CREDENTIALS_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customAuthenticationType;
    private final Map<String, String> credentialsMap;

    private CustomAuthCredentials(BuilderImpl builder) {
        this.customAuthenticationType = builder.customAuthenticationType;
        this.credentialsMap = builder.credentialsMap;
    }

    public final String customAuthenticationType() {
        return this.customAuthenticationType;
    }

    public final boolean hasCredentialsMap() {
        return this.credentialsMap != null && !(this.credentialsMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> credentialsMap() {
        return this.credentialsMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customAuthenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialsMap() ? this.credentialsMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAuthCredentials)) {
            return false;
        }
        CustomAuthCredentials other = (CustomAuthCredentials)obj;
        return Objects.equals(this.customAuthenticationType(), other.customAuthenticationType()) && this.hasCredentialsMap() == other.hasCredentialsMap() && Objects.equals(this.credentialsMap(), other.credentialsMap());
    }

    public final String toString() {
        return ToString.builder((String)"CustomAuthCredentials").add("CustomAuthenticationType", (Object)this.customAuthenticationType()).add("CredentialsMap", (Object)(this.credentialsMap() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customAuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.customAuthenticationType()));
            }
            case "credentialsMap": {
                return Optional.ofNullable(clazz.cast(this.credentialsMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomAuthCredentials, T> g) {
        return obj -> g.apply((CustomAuthCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customAuthenticationType;
        private Map<String, String> credentialsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAuthCredentials model) {
            this.customAuthenticationType(model.customAuthenticationType);
            this.credentialsMap(model.credentialsMap);
        }

        public final String getCustomAuthenticationType() {
            return this.customAuthenticationType;
        }

        public final void setCustomAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
        }

        @Override
        public final Builder customAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
            return this;
        }

        public final Map<String, String> getCredentialsMap() {
            if (this.credentialsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.credentialsMap;
        }

        public final void setCredentialsMap(Map<String, String> credentialsMap) {
            this.credentialsMap = CredentialsMapCopier.copy(credentialsMap);
        }

        @Override
        public final Builder credentialsMap(Map<String, String> credentialsMap) {
            this.credentialsMap = CredentialsMapCopier.copy(credentialsMap);
            return this;
        }

        public CustomAuthCredentials build() {
            return new CustomAuthCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomAuthCredentials> {
        public Builder customAuthenticationType(String var1);

        public Builder credentialsMap(Map<String, String> var1);
    }
}

