/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PrefixType {
    FILENAME("FILENAME"),
    PATH("PATH"),
    PATH_AND_FILENAME("PATH_AND_FILENAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PrefixType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PrefixType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PrefixType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PrefixType> knownValues() {
        return Stream.of(PrefixType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

