/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskType {
    ARITHMETIC("Arithmetic"),
    FILTER("Filter"),
    MAP("Map"),
    MAP_ALL("Map_all"),
    MASK("Mask"),
    MERGE("Merge"),
    PASSTHROUGH("Passthrough"),
    TRUNCATE("Truncate"),
    VALIDATE("Validate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskType> VALUE_MAP;
    private final String value;

    private TaskType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskType> knownValues() {
        EnumSet<TaskType> knownValues = EnumSet.allOf(TaskType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskType.class, TaskType::toString);
    }
}

