/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectionMode;
import software.amazon.awssdk.services.appflow.model.ConnectorProfileProperties;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorProfile> {
    private static final SdkField<String> CONNECTOR_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileArn").getter(ConnectorProfile.getter(ConnectorProfile::connectorProfileArn)).setter(ConnectorProfile.setter(Builder::connectorProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileArn").build()}).build();
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(ConnectorProfile.getter(ConnectorProfile::connectorProfileName)).setter(ConnectorProfile.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(ConnectorProfile.getter(ConnectorProfile::connectorTypeAsString)).setter(ConnectorProfile.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorLabel").getter(ConnectorProfile.getter(ConnectorProfile::connectorLabel)).setter(ConnectorProfile.setter(Builder::connectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()}).build();
    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionMode").getter(ConnectorProfile.getter(ConnectorProfile::connectionModeAsString)).setter(ConnectorProfile.setter(Builder::connectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionMode").build()}).build();
    private static final SdkField<String> CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsArn").getter(ConnectorProfile.getter(ConnectorProfile::credentialsArn)).setter(ConnectorProfile.setter(Builder::credentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsArn").build()}).build();
    private static final SdkField<ConnectorProfileProperties> CONNECTOR_PROFILE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorProfileProperties").getter(ConnectorProfile.getter(ConnectorProfile::connectorProfileProperties)).setter(ConnectorProfile.setter(Builder::connectorProfileProperties)).constructor(ConnectorProfileProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileProperties").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ConnectorProfile.getter(ConnectorProfile::createdAt)).setter(ConnectorProfile.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(ConnectorProfile.getter(ConnectorProfile::lastUpdatedAt)).setter(ConnectorProfile.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<PrivateConnectionProvisioningState> PRIVATE_CONNECTION_PROVISIONING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("privateConnectionProvisioningState").getter(ConnectorProfile.getter(ConnectorProfile::privateConnectionProvisioningState)).setter(ConnectorProfile.setter(Builder::privateConnectionProvisioningState)).constructor(PrivateConnectionProvisioningState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateConnectionProvisioningState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_ARN_FIELD, CONNECTOR_PROFILE_NAME_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, CONNECTION_MODE_FIELD, CREDENTIALS_ARN_FIELD, CONNECTOR_PROFILE_PROPERTIES_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, PRIVATE_CONNECTION_PROVISIONING_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectorProfileArn;
    private final String connectorProfileName;
    private final String connectorType;
    private final String connectorLabel;
    private final String connectionMode;
    private final String credentialsArn;
    private final ConnectorProfileProperties connectorProfileProperties;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final PrivateConnectionProvisioningState privateConnectionProvisioningState;

    private ConnectorProfile(BuilderImpl builder) {
        this.connectorProfileArn = builder.connectorProfileArn;
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.connectionMode = builder.connectionMode;
        this.credentialsArn = builder.credentialsArn;
        this.connectorProfileProperties = builder.connectorProfileProperties;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.privateConnectionProvisioningState = builder.privateConnectionProvisioningState;
    }

    public final String connectorProfileArn() {
        return this.connectorProfileArn;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorLabel() {
        return this.connectorLabel;
    }

    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(this.connectionMode);
    }

    public final String connectionModeAsString() {
        return this.connectionMode;
    }

    public final String credentialsArn() {
        return this.credentialsArn;
    }

    public final ConnectorProfileProperties connectorProfileProperties() {
        return this.connectorProfileProperties;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final PrivateConnectionProvisioningState privateConnectionProvisioningState() {
        return this.privateConnectionProvisioningState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateConnectionProvisioningState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorProfile)) {
            return false;
        }
        ConnectorProfile other = (ConnectorProfile)obj;
        return Objects.equals(this.connectorProfileArn(), other.connectorProfileArn()) && Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorLabel(), other.connectorLabel()) && Objects.equals(this.connectionModeAsString(), other.connectionModeAsString()) && Objects.equals(this.credentialsArn(), other.credentialsArn()) && Objects.equals(this.connectorProfileProperties(), other.connectorProfileProperties()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.privateConnectionProvisioningState(), other.privateConnectionProvisioningState());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorProfile").add("ConnectorProfileArn", (Object)this.connectorProfileArn()).add("ConnectorProfileName", (Object)this.connectorProfileName()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorLabel", (Object)this.connectorLabel()).add("ConnectionMode", (Object)this.connectionModeAsString()).add("CredentialsArn", (Object)this.credentialsArn()).add("ConnectorProfileProperties", (Object)this.connectorProfileProperties()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("PrivateConnectionProvisioningState", (Object)this.privateConnectionProvisioningState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorProfileArn": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileArn()));
            }
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorLabel": {
                return Optional.ofNullable(clazz.cast(this.connectorLabel()));
            }
            case "connectionMode": {
                return Optional.ofNullable(clazz.cast(this.connectionModeAsString()));
            }
            case "credentialsArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsArn()));
            }
            case "connectorProfileProperties": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileProperties()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "privateConnectionProvisioningState": {
                return Optional.ofNullable(clazz.cast(this.privateConnectionProvisioningState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorProfile, T> g) {
        return obj -> g.apply((ConnectorProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorProfileArn;
        private String connectorProfileName;
        private String connectorType;
        private String connectorLabel;
        private String connectionMode;
        private String credentialsArn;
        private ConnectorProfileProperties connectorProfileProperties;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private PrivateConnectionProvisioningState privateConnectionProvisioningState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorProfile model) {
            this.connectorProfileArn(model.connectorProfileArn);
            this.connectorProfileName(model.connectorProfileName);
            this.connectorType(model.connectorType);
            this.connectorLabel(model.connectorLabel);
            this.connectionMode(model.connectionMode);
            this.credentialsArn(model.credentialsArn);
            this.connectorProfileProperties(model.connectorProfileProperties);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.privateConnectionProvisioningState(model.privateConnectionProvisioningState);
        }

        public final String getConnectorProfileArn() {
            return this.connectorProfileArn;
        }

        public final void setConnectorProfileArn(String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
        }

        @Override
        @Transient
        public final Builder connectorProfileArn(String connectorProfileArn) {
            this.connectorProfileArn = connectorProfileArn;
            return this;
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return this.connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        @Transient
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getConnectionMode() {
            return this.connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        @Transient
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final String getCredentialsArn() {
            return this.credentialsArn;
        }

        public final void setCredentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
        }

        @Override
        @Transient
        public final Builder credentialsArn(String credentialsArn) {
            this.credentialsArn = credentialsArn;
            return this;
        }

        public final ConnectorProfileProperties.Builder getConnectorProfileProperties() {
            return this.connectorProfileProperties != null ? this.connectorProfileProperties.toBuilder() : null;
        }

        public final void setConnectorProfileProperties(ConnectorProfileProperties.BuilderImpl connectorProfileProperties) {
            this.connectorProfileProperties = connectorProfileProperties != null ? connectorProfileProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder connectorProfileProperties(ConnectorProfileProperties connectorProfileProperties) {
            this.connectorProfileProperties = connectorProfileProperties;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final PrivateConnectionProvisioningState.Builder getPrivateConnectionProvisioningState() {
            return this.privateConnectionProvisioningState != null ? this.privateConnectionProvisioningState.toBuilder() : null;
        }

        public final void setPrivateConnectionProvisioningState(PrivateConnectionProvisioningState.BuilderImpl privateConnectionProvisioningState) {
            this.privateConnectionProvisioningState = privateConnectionProvisioningState != null ? privateConnectionProvisioningState.build() : null;
        }

        @Override
        @Transient
        public final Builder privateConnectionProvisioningState(PrivateConnectionProvisioningState privateConnectionProvisioningState) {
            this.privateConnectionProvisioningState = privateConnectionProvisioningState;
            return this;
        }

        public ConnectorProfile build() {
            return new ConnectorProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorProfile> {
        public Builder connectorProfileArn(String var1);

        public Builder connectorProfileName(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorLabel(String var1);

        public Builder connectionMode(String var1);

        public Builder connectionMode(ConnectionMode var1);

        public Builder credentialsArn(String var1);

        public Builder connectorProfileProperties(ConnectorProfileProperties var1);

        default public Builder connectorProfileProperties(Consumer<ConnectorProfileProperties.Builder> connectorProfileProperties) {
            return this.connectorProfileProperties((ConnectorProfileProperties)((ConnectorProfileProperties.Builder)ConnectorProfileProperties.builder().applyMutation(connectorProfileProperties)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder privateConnectionProvisioningState(PrivateConnectionProvisioningState var1);

        default public Builder privateConnectionProvisioningState(Consumer<PrivateConnectionProvisioningState.Builder> privateConnectionProvisioningState) {
            return this.privateConnectionProvisioningState((PrivateConnectionProvisioningState)((PrivateConnectionProvisioningState.Builder)PrivateConnectionProvisioningState.builder().applyMutation(privateConnectionProvisioningState)).build());
        }
    }
}

