/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.CustomPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomConnectorSourceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomConnectorSourceProperties> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityName").getter(CustomConnectorSourceProperties.getter(CustomConnectorSourceProperties::entityName)).setter(CustomConnectorSourceProperties.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityName").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customProperties").getter(CustomConnectorSourceProperties.getter(CustomConnectorSourceProperties::customProperties)).setter(CustomConnectorSourceProperties.setter(Builder::customProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD, CUSTOM_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entityName;
    private final Map<String, String> customProperties;

    private CustomConnectorSourceProperties(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.customProperties = builder.customProperties;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final boolean hasCustomProperties() {
        return this.customProperties != null && !(this.customProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customProperties() {
        return this.customProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomProperties() ? this.customProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorSourceProperties)) {
            return false;
        }
        CustomConnectorSourceProperties other = (CustomConnectorSourceProperties)obj;
        return Objects.equals(this.entityName(), other.entityName()) && this.hasCustomProperties() == other.hasCustomProperties() && Objects.equals(this.customProperties(), other.customProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CustomConnectorSourceProperties").add("EntityName", (Object)this.entityName()).add("CustomProperties", this.hasCustomProperties() ? this.customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "customProperties": {
                return Optional.ofNullable(clazz.cast(this.customProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomConnectorSourceProperties, T> g) {
        return obj -> g.apply((CustomConnectorSourceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityName;
        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConnectorSourceProperties model) {
            this.entityName(model.entityName);
            this.customProperties(model.customProperties);
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        @Transient
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (this.customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        @Transient
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        public CustomConnectorSourceProperties build() {
            return new CustomConnectorSourceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomConnectorSourceProperties> {
        public Builder entityName(String var1);

        public Builder customProperties(Map<String, String> var1);
    }
}

