/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.OAuthScopeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HoneycodeMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HoneycodeMetadata> {
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oAuthScopes").getter(HoneycodeMetadata.getter(HoneycodeMetadata::oAuthScopes)).setter(HoneycodeMetadata.setter(Builder::oAuthScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_SCOPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> oAuthScopes;

    private HoneycodeMetadata(BuilderImpl builder) {
        this.oAuthScopes = builder.oAuthScopes;
    }

    public final boolean hasOAuthScopes() {
        return this.oAuthScopes != null && !(this.oAuthScopes instanceof SdkAutoConstructList);
    }

    public final List<String> oAuthScopes() {
        return this.oAuthScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOAuthScopes() ? this.oAuthScopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoneycodeMetadata)) {
            return false;
        }
        HoneycodeMetadata other = (HoneycodeMetadata)obj;
        return this.hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(this.oAuthScopes(), other.oAuthScopes());
    }

    public final String toString() {
        return ToString.builder((String)"HoneycodeMetadata").add("OAuthScopes", this.hasOAuthScopes() ? this.oAuthScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.oAuthScopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HoneycodeMetadata, T> g) {
        return obj -> g.apply((HoneycodeMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HoneycodeMetadata model) {
            this.oAuthScopes(model.oAuthScopes);
        }

        public final Collection<String> getOAuthScopes() {
            if (this.oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oAuthScopes;
        }

        @Override
        public final Builder oAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(String ... oAuthScopes) {
            this.oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
        }

        public HoneycodeMetadata build() {
            return new HoneycodeMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HoneycodeMetadata> {
        public Builder oAuthScopes(Collection<String> var1);

        public Builder oAuthScopes(String ... var1);
    }
}

