/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorEntityRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, DescribeConnectorEntityRequest> {
    private static final SdkField<String> CONNECTOR_ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorEntityName").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::connectorEntityName)).setter(DescribeConnectorEntityRequest.setter(Builder::connectorEntityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityName").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::connectorTypeAsString)).setter(DescribeConnectorEntityRequest.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProfileName").getter(DescribeConnectorEntityRequest.getter(DescribeConnectorEntityRequest::connectorProfileName)).setter(DescribeConnectorEntityRequest.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_NAME_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_PROFILE_NAME_FIELD));
    private final String connectorEntityName;
    private final String connectorType;
    private final String connectorProfileName;

    private DescribeConnectorEntityRequest(BuilderImpl builder) {
        super(builder);
        this.connectorEntityName = builder.connectorEntityName;
        this.connectorType = builder.connectorType;
        this.connectorProfileName = builder.connectorProfileName;
    }

    public final String connectorEntityName() {
        return this.connectorEntityName;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorEntityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorEntityRequest)) {
            return false;
        }
        DescribeConnectorEntityRequest other = (DescribeConnectorEntityRequest)((Object)obj);
        return Objects.equals(this.connectorEntityName(), other.connectorEntityName()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorProfileName(), other.connectorProfileName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorEntityRequest").add("ConnectorEntityName", (Object)this.connectorEntityName()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorProfileName", (Object)this.connectorProfileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorEntityName": {
                return Optional.ofNullable(clazz.cast(this.connectorEntityName()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorEntityRequest, T> g) {
        return obj -> g.apply((DescribeConnectorEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorEntityName;
        private String connectorType;
        private String connectorProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorEntityRequest model) {
            super(model);
            this.connectorEntityName(model.connectorEntityName);
            this.connectorType(model.connectorType);
            this.connectorProfileName(model.connectorProfileName);
        }

        public final String getConnectorEntityName() {
            return this.connectorEntityName;
        }

        @Override
        public final Builder connectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
            return this;
        }

        public final void setConnectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorEntityRequest build() {
            return new DescribeConnectorEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorEntityRequest> {
        public Builder connectorEntityName(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorProfileName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

