/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that determines how Amazon AppFlow formats the flow output data when Upsolver is used as the
 * destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpsolverS3OutputFormatConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpsolverS3OutputFormatConfig.Builder, UpsolverS3OutputFormatConfig> {
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileType").getter(getter(UpsolverS3OutputFormatConfig::fileTypeAsString))
            .setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final SdkField<PrefixConfig> PREFIX_CONFIG_FIELD = SdkField.<PrefixConfig> builder(MarshallingType.SDK_POJO)
            .memberName("prefixConfig").getter(getter(UpsolverS3OutputFormatConfig::prefixConfig))
            .setter(setter(Builder::prefixConfig)).constructor(PrefixConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixConfig").build()).build();

    private static final SdkField<AggregationConfig> AGGREGATION_CONFIG_FIELD = SdkField
            .<AggregationConfig> builder(MarshallingType.SDK_POJO).memberName("aggregationConfig")
            .getter(getter(UpsolverS3OutputFormatConfig::aggregationConfig)).setter(setter(Builder::aggregationConfig))
            .constructor(AggregationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TYPE_FIELD,
            PREFIX_CONFIG_FIELD, AGGREGATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileType;

    private final PrefixConfig prefixConfig;

    private final AggregationConfig aggregationConfig;

    private UpsolverS3OutputFormatConfig(BuilderImpl builder) {
        this.fileType = builder.fileType;
        this.prefixConfig = builder.prefixConfig;
        this.aggregationConfig = builder.aggregationConfig;
    }

    /**
     * <p>
     * Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
     * @see FileType
     */
    public final FileType fileType() {
        return FileType.fromValue(fileType);
    }

    /**
     * <p>
     * Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
     * @see FileType
     */
    public final String fileTypeAsString() {
        return fileType;
    }

    /**
     * Returns the value of the PrefixConfig property for this object.
     * 
     * @return The value of the PrefixConfig property for this object.
     */
    public final PrefixConfig prefixConfig() {
        return prefixConfig;
    }

    /**
     * Returns the value of the AggregationConfig property for this object.
     * 
     * @return The value of the AggregationConfig property for this object.
     */
    public final AggregationConfig aggregationConfig() {
        return aggregationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefixConfig());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsolverS3OutputFormatConfig)) {
            return false;
        }
        UpsolverS3OutputFormatConfig other = (UpsolverS3OutputFormatConfig) obj;
        return Objects.equals(fileTypeAsString(), other.fileTypeAsString())
                && Objects.equals(prefixConfig(), other.prefixConfig())
                && Objects.equals(aggregationConfig(), other.aggregationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpsolverS3OutputFormatConfig").add("FileType", fileTypeAsString())
                .add("PrefixConfig", prefixConfig()).add("AggregationConfig", aggregationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileTypeAsString()));
        case "prefixConfig":
            return Optional.ofNullable(clazz.cast(prefixConfig()));
        case "aggregationConfig":
            return Optional.ofNullable(clazz.cast(aggregationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpsolverS3OutputFormatConfig, T> g) {
        return obj -> g.apply((UpsolverS3OutputFormatConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpsolverS3OutputFormatConfig> {
        /**
         * <p>
         * Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
         * </p>
         * 
         * @param fileType
         *        Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
         * </p>
         * 
         * @param fileType
         *        Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(FileType fileType);

        /**
         * Sets the value of the PrefixConfig property for this object.
         *
         * @param prefixConfig
         *        The new value for the PrefixConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixConfig(PrefixConfig prefixConfig);

        /**
         * Sets the value of the PrefixConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link PrefixConfig.Builder} avoiding the need to
         * create one manually via {@link PrefixConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PrefixConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixConfig(PrefixConfig)}.
         * 
         * @param prefixConfig
         *        a consumer that will call methods on {@link PrefixConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixConfig(PrefixConfig)
         */
        default Builder prefixConfig(Consumer<PrefixConfig.Builder> prefixConfig) {
            return prefixConfig(PrefixConfig.builder().applyMutation(prefixConfig).build());
        }

        /**
         * Sets the value of the AggregationConfig property for this object.
         *
         * @param aggregationConfig
         *        The new value for the AggregationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationConfig(AggregationConfig aggregationConfig);

        /**
         * Sets the value of the AggregationConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link AggregationConfig.Builder} avoiding the need to
         * create one manually via {@link AggregationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AggregationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationConfig(AggregationConfig)}.
         * 
         * @param aggregationConfig
         *        a consumer that will call methods on {@link AggregationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationConfig(AggregationConfig)
         */
        default Builder aggregationConfig(Consumer<AggregationConfig.Builder> aggregationConfig) {
            return aggregationConfig(AggregationConfig.builder().applyMutation(aggregationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fileType;

        private PrefixConfig prefixConfig;

        private AggregationConfig aggregationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpsolverS3OutputFormatConfig model) {
            fileType(model.fileType);
            prefixConfig(model.prefixConfig);
            aggregationConfig(model.aggregationConfig);
        }

        public final String getFileType() {
            return fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public final PrefixConfig.Builder getPrefixConfig() {
            return prefixConfig != null ? prefixConfig.toBuilder() : null;
        }

        @Override
        public final Builder prefixConfig(PrefixConfig prefixConfig) {
            this.prefixConfig = prefixConfig;
            return this;
        }

        public final void setPrefixConfig(PrefixConfig.BuilderImpl prefixConfig) {
            this.prefixConfig = prefixConfig != null ? prefixConfig.build() : null;
        }

        public final AggregationConfig.Builder getAggregationConfig() {
            return aggregationConfig != null ? aggregationConfig.toBuilder() : null;
        }

        @Override
        public final Builder aggregationConfig(AggregationConfig aggregationConfig) {
            this.aggregationConfig = aggregationConfig;
            return this;
        }

        public final void setAggregationConfig(AggregationConfig.BuilderImpl aggregationConfig) {
            this.aggregationConfig = aggregationConfig != null ? aggregationConfig.build() : null;
        }

        @Override
        public UpsolverS3OutputFormatConfig build() {
            return new UpsolverS3OutputFormatConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
