/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowResponse extends AppflowResponse implements
        ToCopyableBuilder<DescribeFlowResponse.Builder, DescribeFlowResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowArn").getter(getter(DescribeFlowResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeFlowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(DescribeFlowResponse::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsArn")
            .getter(getter(DescribeFlowResponse::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsArn").build()).build();

    private static final SdkField<String> FLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowStatus").getter(getter(DescribeFlowResponse::flowStatusAsString))
            .setter(setter(Builder::flowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatus").build()).build();

    private static final SdkField<String> FLOW_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowStatusMessage").getter(getter(DescribeFlowResponse::flowStatusMessage))
            .setter(setter(Builder::flowStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatusMessage").build()).build();

    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField
            .<SourceFlowConfig> builder(MarshallingType.SDK_POJO).memberName("sourceFlowConfig")
            .getter(getter(DescribeFlowResponse::sourceFlowConfig)).setter(setter(Builder::sourceFlowConfig))
            .constructor(SourceFlowConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFlowConfig").build()).build();

    private static final SdkField<List<DestinationFlowConfig>> DESTINATION_FLOW_CONFIG_LIST_FIELD = SdkField
            .<List<DestinationFlowConfig>> builder(MarshallingType.LIST)
            .memberName("destinationFlowConfigList")
            .getter(getter(DescribeFlowResponse::destinationFlowConfigList))
            .setter(setter(Builder::destinationFlowConfigList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationFlowConfigList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationFlowConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationFlowConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExecutionDetails> LAST_RUN_EXECUTION_DETAILS_FIELD = SdkField
            .<ExecutionDetails> builder(MarshallingType.SDK_POJO).memberName("lastRunExecutionDetails")
            .getter(getter(DescribeFlowResponse::lastRunExecutionDetails)).setter(setter(Builder::lastRunExecutionDetails))
            .constructor(ExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunExecutionDetails").build())
            .build();

    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField
            .<TriggerConfig> builder(MarshallingType.SDK_POJO).memberName("triggerConfig")
            .getter(getter(DescribeFlowResponse::triggerConfig)).setter(setter(Builder::triggerConfig))
            .constructor(TriggerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfig").build()).build();

    private static final SdkField<List<Task>> TASKS_FIELD = SdkField
            .<List<Task>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(DescribeFlowResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Task> builder(MarshallingType.SDK_POJO)
                                            .constructor(Task::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeFlowResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(DescribeFlowResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(DescribeFlowResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(DescribeFlowResponse::lastUpdatedBy))
            .setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeFlowResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            DESCRIPTION_FIELD, FLOW_NAME_FIELD, KMS_ARN_FIELD, FLOW_STATUS_FIELD, FLOW_STATUS_MESSAGE_FIELD,
            SOURCE_FLOW_CONFIG_FIELD, DESTINATION_FLOW_CONFIG_LIST_FIELD, LAST_RUN_EXECUTION_DETAILS_FIELD, TRIGGER_CONFIG_FIELD,
            TASKS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));

    private final String flowArn;

    private final String description;

    private final String flowName;

    private final String kmsArn;

    private final String flowStatus;

    private final String flowStatusMessage;

    private final SourceFlowConfig sourceFlowConfig;

    private final List<DestinationFlowConfig> destinationFlowConfigList;

    private final ExecutionDetails lastRunExecutionDetails;

    private final TriggerConfig triggerConfig;

    private final List<Task> tasks;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String createdBy;

    private final String lastUpdatedBy;

    private final Map<String, String> tags;

    private DescribeFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.description = builder.description;
        this.flowName = builder.flowName;
        this.kmsArn = builder.kmsArn;
        this.flowStatus = builder.flowStatus;
        this.flowStatusMessage = builder.flowStatusMessage;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.destinationFlowConfigList = builder.destinationFlowConfigList;
        this.lastRunExecutionDetails = builder.lastRunExecutionDetails;
        this.triggerConfig = builder.triggerConfig;
        this.tasks = builder.tasks;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The flow's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The flow's Amazon Resource Name (ARN).
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * <p>
     * A description of the flow.
     * </p>
     * 
     * @return A description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     * </p>
     * 
     * @return The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is
     * required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon
     * AppFlow uses the Amazon AppFlow-managed KMS key.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This
     *         is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything
     *         here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * Indicates the current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowStatus} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the flow.
     * @see FlowStatus
     */
    public final FlowStatus flowStatus() {
        return FlowStatus.fromValue(flowStatus);
    }

    /**
     * <p>
     * Indicates the current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowStatus} will
     * return {@link FlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowStatusAsString}.
     * </p>
     * 
     * @return Indicates the current status of the flow.
     * @see FlowStatus
     */
    public final String flowStatusAsString() {
        return flowStatus;
    }

    /**
     * <p>
     * Contains an error message if the flow status is in a suspended or error state. This applies only to scheduled or
     * event-triggered flows.
     * </p>
     * 
     * @return Contains an error message if the flow status is in a suspended or error state. This applies only to
     *         scheduled or event-triggered flows.
     */
    public final String flowStatusMessage() {
        return flowStatusMessage;
    }

    /**
     * <p>
     * The configuration that controls how Amazon AppFlow retrieves data from the source connector.
     * </p>
     * 
     * @return The configuration that controls how Amazon AppFlow retrieves data from the source connector.
     */
    public final SourceFlowConfig sourceFlowConfig() {
        return sourceFlowConfig;
    }

    /**
     * Returns true if the DestinationFlowConfigList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationFlowConfigList() {
        return destinationFlowConfigList != null && !(destinationFlowConfigList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationFlowConfigList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration that controls how Amazon AppFlow transfers data to the destination connector.
     */
    public final List<DestinationFlowConfig> destinationFlowConfigList() {
        return destinationFlowConfigList;
    }

    /**
     * <p>
     * Describes the details of the most recent flow run.
     * </p>
     * 
     * @return Describes the details of the most recent flow run.
     */
    public final ExecutionDetails lastRunExecutionDetails() {
        return lastRunExecutionDetails;
    }

    /**
     * <p>
     * The trigger settings that determine how and when the flow runs.
     * </p>
     * 
     * @return The trigger settings that determine how and when the flow runs.
     */
    public final TriggerConfig triggerConfig() {
        return triggerConfig;
    }

    /**
     * Returns true if the Tasks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    public final List<Task> tasks() {
        return tasks;
    }

    /**
     * <p>
     * Specifies when the flow was created.
     * </p>
     * 
     * @return Specifies when the flow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies when the flow was last updated.
     * </p>
     * 
     * @return Specifies when the flow was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The ARN of the user who created the flow.
     * </p>
     * 
     * @return The ARN of the user who created the flow.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Specifies the user name of the account that performed the most recent update.
     * </p>
     * 
     * @return Specifies the user name of the account that performed the most recent update.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for your flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for your flow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flowStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationFlowConfigList() ? destinationFlowConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastRunExecutionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(triggerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowResponse)) {
            return false;
        }
        DescribeFlowResponse other = (DescribeFlowResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(description(), other.description())
                && Objects.equals(flowName(), other.flowName()) && Objects.equals(kmsArn(), other.kmsArn())
                && Objects.equals(flowStatusAsString(), other.flowStatusAsString())
                && Objects.equals(flowStatusMessage(), other.flowStatusMessage())
                && Objects.equals(sourceFlowConfig(), other.sourceFlowConfig())
                && hasDestinationFlowConfigList() == other.hasDestinationFlowConfigList()
                && Objects.equals(destinationFlowConfigList(), other.destinationFlowConfigList())
                && Objects.equals(lastRunExecutionDetails(), other.lastRunExecutionDetails())
                && Objects.equals(triggerConfig(), other.triggerConfig()) && hasTasks() == other.hasTasks()
                && Objects.equals(tasks(), other.tasks()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlowResponse").add("FlowArn", flowArn()).add("Description", description())
                .add("FlowName", flowName()).add("KmsArn", kmsArn()).add("FlowStatus", flowStatusAsString())
                .add("FlowStatusMessage", flowStatusMessage()).add("SourceFlowConfig", sourceFlowConfig())
                .add("DestinationFlowConfigList", hasDestinationFlowConfigList() ? destinationFlowConfigList() : null)
                .add("LastRunExecutionDetails", lastRunExecutionDetails()).add("TriggerConfig", triggerConfig())
                .add("Tasks", hasTasks() ? tasks() : null).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("CreatedBy", createdBy()).add("LastUpdatedBy", lastUpdatedBy()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "kmsArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "flowStatus":
            return Optional.ofNullable(clazz.cast(flowStatusAsString()));
        case "flowStatusMessage":
            return Optional.ofNullable(clazz.cast(flowStatusMessage()));
        case "sourceFlowConfig":
            return Optional.ofNullable(clazz.cast(sourceFlowConfig()));
        case "destinationFlowConfigList":
            return Optional.ofNullable(clazz.cast(destinationFlowConfigList()));
        case "lastRunExecutionDetails":
            return Optional.ofNullable(clazz.cast(lastRunExecutionDetails()));
        case "triggerConfig":
            return Optional.ofNullable(clazz.cast(triggerConfig()));
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowResponse, T> g) {
        return obj -> g.apply((DescribeFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFlowResponse> {
        /**
         * <p>
         * The flow's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param flowArn
         *        The flow's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * A description of the flow.
         * </p>
         * 
         * @param description
         *        A description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * </p>
         * 
         * @param flowName
         *        The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is
         * required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here,
         * Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * </p>
         * 
         * @param kmsArn
         *        The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         *        This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide
         *        anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * Indicates the current status of the flow.
         * </p>
         * 
         * @param flowStatus
         *        Indicates the current status of the flow.
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder flowStatus(String flowStatus);

        /**
         * <p>
         * Indicates the current status of the flow.
         * </p>
         * 
         * @param flowStatus
         *        Indicates the current status of the flow.
         * @see FlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowStatus
         */
        Builder flowStatus(FlowStatus flowStatus);

        /**
         * <p>
         * Contains an error message if the flow status is in a suspended or error state. This applies only to scheduled
         * or event-triggered flows.
         * </p>
         * 
         * @param flowStatusMessage
         *        Contains an error message if the flow status is in a suspended or error state. This applies only to
         *        scheduled or event-triggered flows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowStatusMessage(String flowStatusMessage);

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow retrieves data from the source connector.
         * </p>
         * 
         * @param sourceFlowConfig
         *        The configuration that controls how Amazon AppFlow retrieves data from the source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig);

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow retrieves data from the source connector.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceFlowConfig.Builder} avoiding the need to
         * create one manually via {@link SourceFlowConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceFlowConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFlowConfig(SourceFlowConfig)}.
         * 
         * @param sourceFlowConfig
         *        a consumer that will call methods on {@link SourceFlowConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFlowConfig(SourceFlowConfig)
         */
        default Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return sourceFlowConfig(SourceFlowConfig.builder().applyMutation(sourceFlowConfig).build());
        }

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * </p>
         * 
         * @param destinationFlowConfigList
         *        The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList);

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * </p>
         * 
         * @param destinationFlowConfigList
         *        The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFlowConfigList(DestinationFlowConfig... destinationFlowConfigList);

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DestinationFlowConfig>.Builder} avoiding
         * the need to create one manually via {@link List<DestinationFlowConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DestinationFlowConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationFlowConfigList(List<DestinationFlowConfig>)}.
         * 
         * @param destinationFlowConfigList
         *        a consumer that will call methods on {@link List<DestinationFlowConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationFlowConfigList(List<DestinationFlowConfig>)
         */
        Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder>... destinationFlowConfigList);

        /**
         * <p>
         * Describes the details of the most recent flow run.
         * </p>
         * 
         * @param lastRunExecutionDetails
         *        Describes the details of the most recent flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunExecutionDetails(ExecutionDetails lastRunExecutionDetails);

        /**
         * <p>
         * Describes the details of the most recent flow run.
         * </p>
         * This is a convenience that creates an instance of the {@link ExecutionDetails.Builder} avoiding the need to
         * create one manually via {@link ExecutionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #lastRunExecutionDetails(ExecutionDetails)}.
         * 
         * @param lastRunExecutionDetails
         *        a consumer that will call methods on {@link ExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRunExecutionDetails(ExecutionDetails)
         */
        default Builder lastRunExecutionDetails(Consumer<ExecutionDetails.Builder> lastRunExecutionDetails) {
            return lastRunExecutionDetails(ExecutionDetails.builder().applyMutation(lastRunExecutionDetails).build());
        }

        /**
         * <p>
         * The trigger settings that determine how and when the flow runs.
         * </p>
         * 
         * @param triggerConfig
         *        The trigger settings that determine how and when the flow runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfig(TriggerConfig triggerConfig);

        /**
         * <p>
         * The trigger settings that determine how and when the flow runs.
         * </p>
         * This is a convenience that creates an instance of the {@link TriggerConfig.Builder} avoiding the need to
         * create one manually via {@link TriggerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TriggerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #triggerConfig(TriggerConfig)}.
         * 
         * @param triggerConfig
         *        a consumer that will call methods on {@link TriggerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfig(TriggerConfig)
         */
        default Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return triggerConfig(TriggerConfig.builder().applyMutation(triggerConfig).build());
        }

        /**
         * <p>
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * </p>
         * 
         * @param tasks
         *        A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<Task> tasks);

        /**
         * <p>
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * </p>
         * 
         * @param tasks
         *        A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Task... tasks);

        /**
         * <p>
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Task>.Builder} avoiding the need to create
         * one manually via {@link List<Task>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Task>.Builder#build()} is called immediately and its result
         * is passed to {@link #tasks(List<Task>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on {@link List<Task>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(List<Task>)
         */
        Builder tasks(Consumer<Task.Builder>... tasks);

        /**
         * <p>
         * Specifies when the flow was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies when the flow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies when the flow was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies when the flow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The ARN of the user who created the flow.
         * </p>
         * 
         * @param createdBy
         *        The ARN of the user who created the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Specifies the user name of the account that performed the most recent update.
         * </p>
         * 
         * @param lastUpdatedBy
         *        Specifies the user name of the account that performed the most recent update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The tags used to organize, track, or control access for your flow.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for your flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private String flowArn;

        private String description;

        private String flowName;

        private String kmsArn;

        private String flowStatus;

        private String flowStatusMessage;

        private SourceFlowConfig sourceFlowConfig;

        private List<DestinationFlowConfig> destinationFlowConfigList = DefaultSdkAutoConstructList.getInstance();

        private ExecutionDetails lastRunExecutionDetails;

        private TriggerConfig triggerConfig;

        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String createdBy;

        private String lastUpdatedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowResponse model) {
            super(model);
            flowArn(model.flowArn);
            description(model.description);
            flowName(model.flowName);
            kmsArn(model.kmsArn);
            flowStatus(model.flowStatus);
            flowStatusMessage(model.flowStatusMessage);
            sourceFlowConfig(model.sourceFlowConfig);
            destinationFlowConfigList(model.destinationFlowConfigList);
            lastRunExecutionDetails(model.lastRunExecutionDetails);
            triggerConfig(model.triggerConfig);
            tasks(model.tasks);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            createdBy(model.createdBy);
            lastUpdatedBy(model.lastUpdatedBy);
            tags(model.tags);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFlowName() {
            return flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        public final String getFlowStatus() {
            return flowStatus;
        }

        @Override
        public final Builder flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        @Override
        public final Builder flowStatus(FlowStatus flowStatus) {
            this.flowStatus(flowStatus == null ? null : flowStatus.toString());
            return this;
        }

        public final void setFlowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
        }

        public final String getFlowStatusMessage() {
            return flowStatusMessage;
        }

        @Override
        public final Builder flowStatusMessage(String flowStatusMessage) {
            this.flowStatusMessage = flowStatusMessage;
            return this;
        }

        public final void setFlowStatusMessage(String flowStatusMessage) {
            this.flowStatusMessage = flowStatusMessage;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return sourceFlowConfig != null ? sourceFlowConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        public final Collection<DestinationFlowConfig.Builder> getDestinationFlowConfigList() {
            if (destinationFlowConfigList instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationFlowConfigList != null ? destinationFlowConfigList.stream().map(DestinationFlowConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copy(destinationFlowConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(DestinationFlowConfig... destinationFlowConfigList) {
            destinationFlowConfigList(Arrays.asList(destinationFlowConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder>... destinationFlowConfigList) {
            destinationFlowConfigList(Stream.of(destinationFlowConfigList)
                    .map(c -> DestinationFlowConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationFlowConfigList(Collection<DestinationFlowConfig.BuilderImpl> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copyFromBuilder(destinationFlowConfigList);
        }

        public final ExecutionDetails.Builder getLastRunExecutionDetails() {
            return lastRunExecutionDetails != null ? lastRunExecutionDetails.toBuilder() : null;
        }

        @Override
        public final Builder lastRunExecutionDetails(ExecutionDetails lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails;
            return this;
        }

        public final void setLastRunExecutionDetails(ExecutionDetails.BuilderImpl lastRunExecutionDetails) {
            this.lastRunExecutionDetails = lastRunExecutionDetails != null ? lastRunExecutionDetails.build() : null;
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return triggerConfig != null ? triggerConfig.toBuilder() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        public final Collection<Task.Builder> getTasks() {
            if (tasks instanceof SdkAutoConstructList) {
                return null;
            }
            return tasks != null ? tasks.stream().map(Task::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> Task.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeFlowResponse build() {
            return new DescribeFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
