/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.ConnectorConfiguration;
import software.amazon.awssdk.services.appflow.model.ConnectorConfigurationsMapCopier;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorsResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, DescribeConnectorsResponse> {
    private static final SdkField<Map<String, ConnectorConfiguration>> CONNECTOR_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("connectorConfigurations").getter(DescribeConnectorsResponse.getter(DescribeConnectorsResponse::connectorConfigurationsAsStrings)).setter(DescribeConnectorsResponse.setter(Builder::connectorConfigurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeConnectorsResponse.getter(DescribeConnectorsResponse::nextToken)).setter(DescribeConnectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final Map<String, ConnectorConfiguration> connectorConfigurations;
    private final String nextToken;

    private DescribeConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorConfigurations = builder.connectorConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final Map<ConnectorType, ConnectorConfiguration> connectorConfigurations() {
        return ConnectorConfigurationsMapCopier.copyStringToEnum(this.connectorConfigurations);
    }

    public final boolean hasConnectorConfigurations() {
        return this.connectorConfigurations != null && !(this.connectorConfigurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, ConnectorConfiguration> connectorConfigurationsAsStrings() {
        return this.connectorConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorConfigurations() ? this.connectorConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorsResponse)) {
            return false;
        }
        DescribeConnectorsResponse other = (DescribeConnectorsResponse)((Object)obj);
        return this.hasConnectorConfigurations() == other.hasConnectorConfigurations() && Objects.equals(this.connectorConfigurationsAsStrings(), other.connectorConfigurationsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorsResponse").add("ConnectorConfigurations", this.hasConnectorConfigurations() ? this.connectorConfigurationsAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorConfigurations": {
                return Optional.ofNullable(clazz.cast(this.connectorConfigurationsAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorsResponse, T> g) {
        return obj -> g.apply((DescribeConnectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private Map<String, ConnectorConfiguration> connectorConfigurations = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorsResponse model) {
            super(model);
            this.connectorConfigurationsWithStrings(model.connectorConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Map<String, ConnectorConfiguration.Builder> getConnectorConfigurations() {
            if (this.connectorConfigurations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectorConfigurations != null ? CollectionUtils.mapValues(this.connectorConfigurations, ConnectorConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder connectorConfigurationsWithStrings(Map<String, ConnectorConfiguration> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copy(connectorConfigurations);
            return this;
        }

        @Override
        public final Builder connectorConfigurations(Map<ConnectorType, ConnectorConfiguration> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copyEnumToString(connectorConfigurations);
            return this;
        }

        public final void setConnectorConfigurations(Map<String, ConnectorConfiguration.BuilderImpl> connectorConfigurations) {
            this.connectorConfigurations = ConnectorConfigurationsMapCopier.copyFromBuilder(connectorConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConnectorsResponse build() {
            return new DescribeConnectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorsResponse> {
        public Builder connectorConfigurationsWithStrings(Map<String, ConnectorConfiguration> var1);

        public Builder connectorConfigurations(Map<ConnectorType, ConnectorConfiguration> var1);

        public Builder nextToken(String var1);
    }
}

