/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.ConnectorEntityField;
import software.amazon.awssdk.services.appflow.model.ConnectorEntityFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorEntityResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, DescribeConnectorEntityResponse> {
    private static final SdkField<List<ConnectorEntityField>> CONNECTOR_ENTITY_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorEntityFields").getter(DescribeConnectorEntityResponse.getter(DescribeConnectorEntityResponse::connectorEntityFields)).setter(DescribeConnectorEntityResponse.setter(Builder::connectorEntityFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorEntityField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_FIELDS_FIELD));
    private final List<ConnectorEntityField> connectorEntityFields;

    private DescribeConnectorEntityResponse(BuilderImpl builder) {
        super(builder);
        this.connectorEntityFields = builder.connectorEntityFields;
    }

    public boolean hasConnectorEntityFields() {
        return this.connectorEntityFields != null && !(this.connectorEntityFields instanceof SdkAutoConstructList);
    }

    public List<ConnectorEntityField> connectorEntityFields() {
        return this.connectorEntityFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorEntityFields() ? this.connectorEntityFields() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorEntityResponse)) {
            return false;
        }
        DescribeConnectorEntityResponse other = (DescribeConnectorEntityResponse)((Object)obj);
        return this.hasConnectorEntityFields() == other.hasConnectorEntityFields() && Objects.equals(this.connectorEntityFields(), other.connectorEntityFields());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConnectorEntityResponse").add("ConnectorEntityFields", this.hasConnectorEntityFields() ? this.connectorEntityFields() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorEntityFields": {
                return Optional.ofNullable(clazz.cast(this.connectorEntityFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorEntityResponse, T> g) {
        return obj -> g.apply((DescribeConnectorEntityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private List<ConnectorEntityField> connectorEntityFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorEntityResponse model) {
            super(model);
            this.connectorEntityFields(model.connectorEntityFields);
        }

        public final Collection<ConnectorEntityField.Builder> getConnectorEntityFields() {
            if (this.connectorEntityFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorEntityFields != null ? (Collection)this.connectorEntityFields.stream().map(ConnectorEntityField::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectorEntityFields(Collection<ConnectorEntityField> connectorEntityFields) {
            this.connectorEntityFields = ConnectorEntityFieldListCopier.copy(connectorEntityFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorEntityFields(ConnectorEntityField ... connectorEntityFields) {
            this.connectorEntityFields(Arrays.asList(connectorEntityFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorEntityFields(Consumer<ConnectorEntityField.Builder> ... connectorEntityFields) {
            this.connectorEntityFields(Stream.of(connectorEntityFields).map(c -> (ConnectorEntityField)((ConnectorEntityField.Builder)ConnectorEntityField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectorEntityFields(Collection<ConnectorEntityField.BuilderImpl> connectorEntityFields) {
            this.connectorEntityFields = ConnectorEntityFieldListCopier.copyFromBuilder(connectorEntityFields);
        }

        @Override
        public DescribeConnectorEntityResponse build() {
            return new DescribeConnectorEntityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorEntityResponse> {
        public Builder connectorEntityFields(Collection<ConnectorEntityField> var1);

        public Builder connectorEntityFields(ConnectorEntityField ... var1);

        public Builder connectorEntityFields(Consumer<ConnectorEntityField.Builder> ... var1);
    }
}

