/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.DestinationFlowConfig;
import software.amazon.awssdk.services.appflow.model.DestinationFlowConfigListCopier;
import software.amazon.awssdk.services.appflow.model.SourceFlowConfig;
import software.amazon.awssdk.services.appflow.model.TagMapCopier;
import software.amazon.awssdk.services.appflow.model.Task;
import software.amazon.awssdk.services.appflow.model.TasksCopier;
import software.amazon.awssdk.services.appflow.model.TriggerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, CreateFlowRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(CreateFlowRequest.getter(CreateFlowRequest::flowName)).setter(CreateFlowRequest.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateFlowRequest.getter(CreateFlowRequest::description)).setter(CreateFlowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsArn").getter(CreateFlowRequest.getter(CreateFlowRequest::kmsArn)).setter(CreateFlowRequest.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsArn").build()}).build();
    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("triggerConfig").getter(CreateFlowRequest.getter(CreateFlowRequest::triggerConfig)).setter(CreateFlowRequest.setter(Builder::triggerConfig)).constructor(TriggerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfig").build()}).build();
    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceFlowConfig").getter(CreateFlowRequest.getter(CreateFlowRequest::sourceFlowConfig)).setter(CreateFlowRequest.setter(Builder::sourceFlowConfig)).constructor(SourceFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFlowConfig").build()}).build();
    private static final SdkField<List<DestinationFlowConfig>> DESTINATION_FLOW_CONFIG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinationFlowConfigList").getter(CreateFlowRequest.getter(CreateFlowRequest::destinationFlowConfigList)).setter(CreateFlowRequest.setter(Builder::destinationFlowConfigList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationFlowConfigList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Task>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(CreateFlowRequest.getter(CreateFlowRequest::tasks)).setter(CreateFlowRequest.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateFlowRequest.getter(CreateFlowRequest::tags)).setter(CreateFlowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD, DESCRIPTION_FIELD, KMS_ARN_FIELD, TRIGGER_CONFIG_FIELD, SOURCE_FLOW_CONFIG_FIELD, DESTINATION_FLOW_CONFIG_LIST_FIELD, TASKS_FIELD, TAGS_FIELD));
    private final String flowName;
    private final String description;
    private final String kmsArn;
    private final TriggerConfig triggerConfig;
    private final SourceFlowConfig sourceFlowConfig;
    private final List<DestinationFlowConfig> destinationFlowConfigList;
    private final List<Task> tasks;
    private final Map<String, String> tags;

    private CreateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.description = builder.description;
        this.kmsArn = builder.kmsArn;
        this.triggerConfig = builder.triggerConfig;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.destinationFlowConfigList = builder.destinationFlowConfigList;
        this.tasks = builder.tasks;
        this.tags = builder.tags;
    }

    public String flowName() {
        return this.flowName;
    }

    public String description() {
        return this.description;
    }

    public String kmsArn() {
        return this.kmsArn;
    }

    public TriggerConfig triggerConfig() {
        return this.triggerConfig;
    }

    public SourceFlowConfig sourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public boolean hasDestinationFlowConfigList() {
        return this.destinationFlowConfigList != null && !(this.destinationFlowConfigList instanceof SdkAutoConstructList);
    }

    public List<DestinationFlowConfig> destinationFlowConfigList() {
        return this.destinationFlowConfigList;
    }

    public boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public List<Task> tasks() {
        return this.tasks;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationFlowConfigList() ? this.destinationFlowConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowRequest)) {
            return false;
        }
        CreateFlowRequest other = (CreateFlowRequest)((Object)obj);
        return Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsArn(), other.kmsArn()) && Objects.equals(this.triggerConfig(), other.triggerConfig()) && Objects.equals(this.sourceFlowConfig(), other.sourceFlowConfig()) && this.hasDestinationFlowConfigList() == other.hasDestinationFlowConfigList() && Objects.equals(this.destinationFlowConfigList(), other.destinationFlowConfigList()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateFlowRequest").add("FlowName", (Object)this.flowName()).add("Description", (Object)this.description()).add("KmsArn", (Object)this.kmsArn()).add("TriggerConfig", (Object)this.triggerConfig()).add("SourceFlowConfig", (Object)this.sourceFlowConfig()).add("DestinationFlowConfigList", this.hasDestinationFlowConfigList() ? this.destinationFlowConfigList() : null).add("Tasks", this.hasTasks() ? this.tasks() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "kmsArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "triggerConfig": {
                return Optional.ofNullable(clazz.cast(this.triggerConfig()));
            }
            case "sourceFlowConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFlowConfig()));
            }
            case "destinationFlowConfigList": {
                return Optional.ofNullable(clazz.cast(this.destinationFlowConfigList()));
            }
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowRequest, T> g) {
        return obj -> g.apply((CreateFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String flowName;
        private String description;
        private String kmsArn;
        private TriggerConfig triggerConfig;
        private SourceFlowConfig sourceFlowConfig;
        private List<DestinationFlowConfig> destinationFlowConfigList = DefaultSdkAutoConstructList.getInstance();
        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowRequest model) {
            super(model);
            this.flowName(model.flowName);
            this.description(model.description);
            this.kmsArn(model.kmsArn);
            this.triggerConfig(model.triggerConfig);
            this.sourceFlowConfig(model.sourceFlowConfig);
            this.destinationFlowConfigList(model.destinationFlowConfigList);
            this.tasks(model.tasks);
            this.tags(model.tags);
        }

        public final String getFlowName() {
            return this.flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return this.triggerConfig != null ? this.triggerConfig.toBuilder() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return this.sourceFlowConfig != null ? this.sourceFlowConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        public final Collection<DestinationFlowConfig.Builder> getDestinationFlowConfigList() {
            if (this.destinationFlowConfigList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationFlowConfigList != null ? (Collection)this.destinationFlowConfigList.stream().map(DestinationFlowConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copy(destinationFlowConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(DestinationFlowConfig ... destinationFlowConfigList) {
            this.destinationFlowConfigList(Arrays.asList(destinationFlowConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder> ... destinationFlowConfigList) {
            this.destinationFlowConfigList(Stream.of(destinationFlowConfigList).map(c -> (DestinationFlowConfig)((DestinationFlowConfig.Builder)DestinationFlowConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationFlowConfigList(Collection<DestinationFlowConfig.BuilderImpl> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copyFromBuilder(destinationFlowConfigList);
        }

        public final Collection<Task.Builder> getTasks() {
            if (this.tasks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tasks != null ? (Collection)this.tasks.stream().map(Task::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (Task)((Task.Builder)Task.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowRequest build() {
            return new CreateFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowRequest> {
        public Builder flowName(String var1);

        public Builder description(String var1);

        public Builder kmsArn(String var1);

        public Builder triggerConfig(TriggerConfig var1);

        default public Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return this.triggerConfig((TriggerConfig)((TriggerConfig.Builder)TriggerConfig.builder().applyMutation(triggerConfig)).build());
        }

        public Builder sourceFlowConfig(SourceFlowConfig var1);

        default public Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return this.sourceFlowConfig((SourceFlowConfig)((SourceFlowConfig.Builder)SourceFlowConfig.builder().applyMutation(sourceFlowConfig)).build());
        }

        public Builder destinationFlowConfigList(Collection<DestinationFlowConfig> var1);

        public Builder destinationFlowConfigList(DestinationFlowConfig ... var1);

        public Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder> ... var1);

        public Builder tasks(Collection<Task> var1);

        public Builder tasks(Task ... var1);

        public Builder tasks(Consumer<Task.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

