/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeMetadata> {
    private static final SdkField<List<String>> SUPPORTED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedRegions").getter(SnowflakeMetadata.getter(SnowflakeMetadata::supportedRegions)).setter(SnowflakeMetadata.setter(Builder::supportedRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> supportedRegions;

    private SnowflakeMetadata(BuilderImpl builder) {
        this.supportedRegions = builder.supportedRegions;
    }

    public boolean hasSupportedRegions() {
        return this.supportedRegions != null && !(this.supportedRegions instanceof SdkAutoConstructList);
    }

    public List<String> supportedRegions() {
        return this.supportedRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedRegions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeMetadata)) {
            return false;
        }
        SnowflakeMetadata other = (SnowflakeMetadata)obj;
        return Objects.equals(this.supportedRegions(), other.supportedRegions());
    }

    public String toString() {
        return ToString.builder((String)"SnowflakeMetadata").add("SupportedRegions", this.supportedRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "supportedRegions": {
                return Optional.ofNullable(clazz.cast(this.supportedRegions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeMetadata, T> g) {
        return obj -> g.apply((SnowflakeMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeMetadata model) {
            this.supportedRegions(model.supportedRegions);
        }

        public final Collection<String> getSupportedRegions() {
            return this.supportedRegions;
        }

        @Override
        public final Builder supportedRegions(Collection<String> supportedRegions) {
            this.supportedRegions = RegionListCopier.copy(supportedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRegions(String ... supportedRegions) {
            this.supportedRegions(Arrays.asList(supportedRegions));
            return this;
        }

        public final void setSupportedRegions(Collection<String> supportedRegions) {
            this.supportedRegions = RegionListCopier.copy(supportedRegions);
        }

        public SnowflakeMetadata build() {
            return new SnowflakeMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeMetadata> {
        public Builder supportedRegions(Collection<String> var1);

        public Builder supportedRegions(String ... var1);
    }
}

