/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeDestinationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeDestinationProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("object").getter(SnowflakeDestinationProperties.getter(SnowflakeDestinationProperties::object)).setter(SnowflakeDestinationProperties.setter(Builder::object)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()}).build();
    private static final SdkField<String> INTERMEDIATE_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intermediateBucketName").getter(SnowflakeDestinationProperties.getter(SnowflakeDestinationProperties::intermediateBucketName)).setter(SnowflakeDestinationProperties.setter(Builder::intermediateBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateBucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketPrefix").getter(SnowflakeDestinationProperties.getter(SnowflakeDestinationProperties::bucketPrefix)).setter(SnowflakeDestinationProperties.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()}).build();
    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorHandlingConfig").getter(SnowflakeDestinationProperties.getter(SnowflakeDestinationProperties::errorHandlingConfig)).setter(SnowflakeDestinationProperties.setter(Builder::errorHandlingConfig)).constructor(ErrorHandlingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD, INTERMEDIATE_BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, ERROR_HANDLING_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String object;
    private final String intermediateBucketName;
    private final String bucketPrefix;
    private final ErrorHandlingConfig errorHandlingConfig;

    private SnowflakeDestinationProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.intermediateBucketName = builder.intermediateBucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.errorHandlingConfig = builder.errorHandlingConfig;
    }

    public String object() {
        return this.object;
    }

    public String intermediateBucketName() {
        return this.intermediateBucketName;
    }

    public String bucketPrefix() {
        return this.bucketPrefix;
    }

    public ErrorHandlingConfig errorHandlingConfig() {
        return this.errorHandlingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.object());
        hashCode = 31 * hashCode + Objects.hashCode(this.intermediateBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorHandlingConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeDestinationProperties)) {
            return false;
        }
        SnowflakeDestinationProperties other = (SnowflakeDestinationProperties)obj;
        return Objects.equals(this.object(), other.object()) && Objects.equals(this.intermediateBucketName(), other.intermediateBucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix()) && Objects.equals(this.errorHandlingConfig(), other.errorHandlingConfig());
    }

    public String toString() {
        return ToString.builder((String)"SnowflakeDestinationProperties").add("Object", (Object)this.object()).add("IntermediateBucketName", (Object)this.intermediateBucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).add("ErrorHandlingConfig", (Object)this.errorHandlingConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "object": {
                return Optional.ofNullable(clazz.cast(this.object()));
            }
            case "intermediateBucketName": {
                return Optional.ofNullable(clazz.cast(this.intermediateBucketName()));
            }
            case "bucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
            case "errorHandlingConfig": {
                return Optional.ofNullable(clazz.cast(this.errorHandlingConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeDestinationProperties, T> g) {
        return obj -> g.apply((SnowflakeDestinationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String object;
        private String intermediateBucketName;
        private String bucketPrefix;
        private ErrorHandlingConfig errorHandlingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeDestinationProperties model) {
            this.object(model.object);
            this.intermediateBucketName(model.intermediateBucketName);
            this.bucketPrefix(model.bucketPrefix);
            this.errorHandlingConfig(model.errorHandlingConfig);
        }

        public final String getObject() {
            return this.object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        public final String getIntermediateBucketName() {
            return this.intermediateBucketName;
        }

        @Override
        public final Builder intermediateBucketName(String intermediateBucketName) {
            this.intermediateBucketName = intermediateBucketName;
            return this;
        }

        public final void setIntermediateBucketName(String intermediateBucketName) {
            this.intermediateBucketName = intermediateBucketName;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return this.errorHandlingConfig != null ? this.errorHandlingConfig.toBuilder() : null;
        }

        @Override
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        public SnowflakeDestinationProperties build() {
            return new SnowflakeDestinationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeDestinationProperties> {
        public Builder object(String var1);

        public Builder intermediateBucketName(String var1);

        public Builder bucketPrefix(String var1);

        public Builder errorHandlingConfig(ErrorHandlingConfig var1);

        default public Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return this.errorHandlingConfig((ErrorHandlingConfig)((ErrorHandlingConfig.Builder)ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig)).build());
        }
    }
}

